/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.AddConfigNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConfigNodeProcedure
extends AbstractNodeProcedure<AddConfigNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(AddConfigNodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TConfigNodeLocation tConfigNodeLocation;

    public AddConfigNodeProcedure() {
    }

    public AddConfigNodeProcedure(TConfigNodeLocation tConfigNodeLocation) {
        this.tConfigNodeLocation = tConfigNodeLocation;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AddConfigNodeState state) {
        block10: {
            if (this.tConfigNodeLocation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case ADD_CONFIG_NODE_PREPARE: {
                        this.setNextState(AddConfigNodeState.CREATE_PEER);
                        break;
                    }
                    case CREATE_PEER: {
                        env.addConsensusGroup(this.tConfigNodeLocation);
                        this.setNextState(AddConfigNodeState.ADD_PEER);
                        LOG.info("Add consensus group {}", (Object)this.tConfigNodeLocation);
                        break;
                    }
                    case ADD_PEER: {
                        env.addConfigNodePeer(this.tConfigNodeLocation);
                        this.setNextState(AddConfigNodeState.REGISTER_SUCCESS);
                        LOG.info("Add Peer of {}", (Object)this.tConfigNodeLocation);
                        break;
                    }
                    case REGISTER_SUCCESS: {
                        env.notifyRegisterSuccess(this.tConfigNodeLocation);
                        env.applyConfigNode(this.tConfigNodeLocation);
                        env.broadCastTheLatestConfigNodeGroup();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Add Config Node failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to add config node {}, state {}", new Object[]{this.tConfigNodeLocation, state, e});
                if (this.getCycles() <= 5) break block10;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AddConfigNodeState state) throws ProcedureException {
        switch (state) {
            case CREATE_PEER: {
                env.deleteConfigNodePeer(this.tConfigNodeLocation);
                LOG.info("Rollback add consensus group:{}", (Object)this.tConfigNodeLocation);
                break;
            }
            case ADD_PEER: {
                env.removeConfigNodePeer(this.tConfigNodeLocation);
                LOG.info("Rollback remove peer:{}", (Object)this.tConfigNodeLocation);
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(AddConfigNodeState state) {
        switch (state) {
            case CREATE_PEER: 
            case ADD_PEER: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected AddConfigNodeState getState(int stateId) {
        return AddConfigNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(AddConfigNodeState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected AddConfigNodeState getInitialState() {
        return AddConfigNodeState.ADD_CONFIG_NODE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.ADD_CONFIG_NODE_PROCEDURE.ordinal());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTConfigNodeLocation((TConfigNodeLocation)this.tConfigNodeLocation, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.tConfigNodeLocation = ThriftConfigNodeSerDeUtils.deserializeTConfigNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize AddConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof AddConfigNodeProcedure) {
            AddConfigNodeProcedure thatProc = (AddConfigNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.tConfigNodeLocation.equals(this.tConfigNodeLocation);
        }
        return false;
    }
}

