/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateProcedurePlan;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureWAL;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureInfo.class);
    private final ProcedureFactory procedureFactory = ProcedureFactory.getInstance();
    private final String procedureWalDir = CommonDescriptor.getInstance().getConfig().getProcedureWalFolder();
    private final ConcurrentHashMap<Long, ProcedureWAL> procWALMap = new ConcurrentHashMap();

    public void load(List<Procedure> procedureList) {
        try {
            Files.list(Paths.get(this.procedureWalDir, new String[0])).filter(path -> path.getFileName().toString().endsWith(".proc.wal")).sorted((p1, p2) -> Long.compareUnsigned(Long.parseLong(p1.getFileName().toString().split("\\.")[0]), Long.parseLong(p2.getFileName().toString().split("\\.")[0]))).forEach(path -> {
                String fileName = path.getFileName().toString();
                long procId = Long.parseLong(fileName.split("\\.")[0]);
                ProcedureWAL procedureWAL = this.procWALMap.computeIfAbsent(procId, id -> new ProcedureWAL((Path)path, this.procedureFactory));
                procedureWAL.load(procedureList);
            });
        }
        catch (IOException e) {
            LOG.error("Load procedure wal failed.", (Throwable)e);
        }
    }

    public TSStatus updateProcedure(UpdateProcedurePlan updateProcedurePlan) {
        Procedure procedure = updateProcedurePlan.getProcedure();
        long procId = procedure.getProcId();
        Path path = Paths.get(this.procedureWalDir, procId + ".proc.wal");
        ProcedureWAL procedureWAL = this.procWALMap.computeIfAbsent(procId, id -> new ProcedureWAL(path, this.procedureFactory));
        try {
            procedureWAL.save(procedure);
        }
        catch (IOException e) {
            LOG.error("Update Procedure (pid={}) wal failed", (Object)procedure.getProcId(), (Object)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus deleteProcedure(DeleteProcedurePlan deleteProcedurePlan) {
        long procId = deleteProcedurePlan.getProcId();
        ProcedureWAL procedureWAL = this.procWALMap.get(procId);
        if (procedureWAL != null) {
            procedureWAL.delete();
        }
        this.procWALMap.remove(procId);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }
}

