/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.RegionCache;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.partition.RegionHeartbeatSample;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionGroupCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionGroupCache.class);
    private final TConsensusGroupId consensusGroupId;
    private final Map<Integer, RegionCache> regionCacheMap;
    private volatile int leaderDataNodeId;

    public RegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.consensusGroupId = consensusGroupId;
        this.regionCacheMap = new ConcurrentHashMap<Integer, RegionCache>();
        this.leaderDataNodeId = -1;
    }

    public void cacheHeartbeatSample(RegionHeartbeatSample newHeartbeatSample) {
        this.regionCacheMap.computeIfAbsent(newHeartbeatSample.getBelongedDataNodeId(), empty -> new RegionCache()).cacheHeartbeatSample(newHeartbeatSample);
    }

    public boolean updateRegionStatistics() {
        long updateVersion = Long.MIN_VALUE;
        int originLeaderDataNodeId = this.leaderDataNodeId;
        for (Map.Entry<Integer, RegionCache> cacheEntry : this.regionCacheMap.entrySet()) {
            cacheEntry.getValue().updateStatistics();
            Pair<Long, Boolean> isLeader = cacheEntry.getValue().isLeader();
            if ((Long)isLeader.getLeft() <= updateVersion || !((Boolean)isLeader.getRight()).booleanValue()) continue;
            updateVersion = (Long)isLeader.getLeft();
            this.leaderDataNodeId = cacheEntry.getKey();
        }
        return originLeaderDataNodeId != this.leaderDataNodeId;
    }

    public void removeCacheIfExists(int dataNodeId) {
        this.regionCacheMap.remove(dataNodeId);
    }

    public int getLeaderDataNodeId() {
        return this.leaderDataNodeId;
    }

    public RegionStatus getRegionStatus(int dataNodeId) {
        return this.regionCacheMap.containsKey(dataNodeId) ? this.regionCacheMap.get(dataNodeId).getStatus() : RegionStatus.Unknown;
    }

    public RegionGroupStatus getRegionGroupStatus() {
        int unknownCount = 0;
        for (RegionCache regionCache : this.regionCacheMap.values()) {
            if (RegionStatus.ReadOnly.equals((Object)regionCache.getStatus()) || RegionStatus.Removing.equals((Object)regionCache.getStatus())) {
                return RegionGroupStatus.Disabled;
            }
            unknownCount += RegionStatus.Unknown.equals((Object)regionCache.getStatus()) ? 1 : 0;
        }
        if (unknownCount == 0) {
            return RegionGroupStatus.Running;
        }
        return unknownCount <= (this.regionCacheMap.size() - 1) / 2 ? RegionGroupStatus.Available : RegionGroupStatus.Disabled;
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }
}

