/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.partition;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.exception.NotAvailableRegionGroupException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.IPartitionAllocator;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.tsfile.utils.Pair;

public class GreedyPartitionAllocator
implements IPartitionAllocator {
    private static final long TIME_PARTITION_INTERVAL = ConfigNodeDescriptor.getInstance().getConf().getTimePartitionInterval();
    private final IManager configManager;

    public GreedyPartitionAllocator(IManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NotAvailableRegionGroupException {
        ConcurrentHashMap<String, SchemaPartitionTable> result = new ConcurrentHashMap<String, SchemaPartitionTable>();
        for (Map.Entry<String, List<TSeriesPartitionSlot>> slotsMapEntry : unassignedSchemaPartitionSlotsMap.entrySet()) {
            String storageGroup = slotsMapEntry.getKey();
            List<TSeriesPartitionSlot> unassignedPartitionSlots = slotsMapEntry.getValue();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(storageGroup, TConsensusGroupType.SchemaRegion);
            ConcurrentHashMap<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, TConsensusGroupId>();
            for (TSeriesPartitionSlot seriesPartitionSlot : unassignedPartitionSlots) {
                schemaPartitionMap.put(seriesPartitionSlot, (TConsensusGroupId)regionSlotsCounter.get(0).getRight());
                this.bubbleSort((TConsensusGroupId)regionSlotsCounter.get(0).getRight(), regionSlotsCounter);
            }
            result.put(storageGroup, new SchemaPartitionTable(schemaPartitionMap));
        }
        return result;
    }

    @Override
    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap) throws NotAvailableRegionGroupException {
        ConcurrentHashMap<String, DataPartitionTable> result = new ConcurrentHashMap<String, DataPartitionTable>();
        for (Map.Entry<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> slotsMapEntry : unassignedDataPartitionSlotsMap.entrySet()) {
            String storageGroup = slotsMapEntry.getKey();
            Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> unassignedPartitionSlotsMap = slotsMapEntry.getValue();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(storageGroup, TConsensusGroupType.DataRegion);
            DataPartitionTable dataPartitionTable = new DataPartitionTable();
            for (Map.Entry<TSeriesPartitionSlot, List<TTimePartitionSlot>> seriesPartitionEntry : unassignedPartitionSlotsMap.entrySet()) {
                SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                List<TTimePartitionSlot> timePartitionSlots = seriesPartitionEntry.getValue();
                timePartitionSlots.sort(Comparator.comparingLong(TTimePartitionSlot::getStartTime));
                for (TTimePartitionSlot timePartitionSlot : timePartitionSlots) {
                    TConsensusGroupId predecessor = seriesPartitionTable.getPrecededDataPartition(timePartitionSlot, TIME_PARTITION_INTERVAL);
                    if (predecessor != null) {
                        seriesPartitionTable.getSeriesPartitionMap().put(timePartitionSlot, Collections.singletonList(predecessor));
                        this.bubbleSort(predecessor, regionSlotsCounter);
                        continue;
                    }
                    predecessor = this.getPartitionManager().getPrecededDataPartition(storageGroup, seriesPartitionEntry.getKey(), timePartitionSlot, TIME_PARTITION_INTERVAL);
                    if (predecessor != null) {
                        seriesPartitionTable.getSeriesPartitionMap().put(timePartitionSlot, Collections.singletonList(predecessor));
                        this.bubbleSort(predecessor, regionSlotsCounter);
                        continue;
                    }
                    seriesPartitionTable.getSeriesPartitionMap().put(timePartitionSlot, Collections.singletonList((TConsensusGroupId)regionSlotsCounter.get(0).getRight()));
                    this.bubbleSort((TConsensusGroupId)regionSlotsCounter.get(0).getRight(), regionSlotsCounter);
                }
                dataPartitionTable.getDataPartitionMap().put(seriesPartitionEntry.getKey(), seriesPartitionTable);
            }
            result.put(storageGroup, dataPartitionTable);
        }
        return result;
    }

    private void bubbleSort(TConsensusGroupId consensusGroupId, List<Pair<Long, TConsensusGroupId>> regionSlotsCounter) {
        int index = 0;
        for (int i = 0; i < regionSlotsCounter.size(); ++i) {
            if (!((TConsensusGroupId)regionSlotsCounter.get(i).getRight()).equals(consensusGroupId)) continue;
            index = i;
            break;
        }
        regionSlotsCounter.get(index).setLeft((Object)((Long)regionSlotsCounter.get(index).getLeft() + 1L));
        while (index < regionSlotsCounter.size() - 1 && (Long)regionSlotsCounter.get(index).getLeft() > (Long)regionSlotsCounter.get(index + 1).getLeft()) {
            Collections.swap(regionSlotsCounter, index, index + 1);
            ++index;
        }
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

