/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.exception.NotAvailableRegionGroupException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.GreedyPartitionAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.partition.IPartitionAllocator;

public class PartitionBalancer {
    private final IManager configManager;

    public PartitionBalancer(IManager configManager) {
        this.configManager = configManager;
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NotAvailableRegionGroupException {
        return this.genPartitionAllocator().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap) throws NotAvailableRegionGroupException {
        return this.genPartitionAllocator().allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    private IPartitionAllocator genPartitionAllocator() {
        return new GreedyPartitionAllocator(this.configManager);
    }
}

