/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRoutingPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.consensus.statemachine.PartitionRegionStateMachine;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.PermissionManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.SyncManager;
import org.apache.iotdb.confignode.manager.TriggerManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.sync.ClusterSyncInfo;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRoutingResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerJarReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerJarResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
implements IManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private ConsensusManager consensusManager;
    private final NodeManager nodeManager;
    private final ClusterSchemaManager clusterSchemaManager;
    private final PartitionManager partitionManager;
    private final PermissionManager permissionManager;
    private final LoadManager loadManager;
    private final ProcedureManager procedureManager;
    private final UDFManager udfManager;
    private final TriggerManager triggerManager;
    private final SyncManager syncManager;
    private final PartitionRegionStateMachine stateMachine;

    public ConfigManager() throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        ClusterSchemaInfo clusterSchemaInfo = new ClusterSchemaInfo();
        PartitionInfo partitionInfo = new PartitionInfo();
        AuthorInfo authorInfo = new AuthorInfo();
        ProcedureInfo procedureInfo = new ProcedureInfo();
        UDFInfo udfInfo = new UDFInfo();
        TriggerInfo triggerInfo = new TriggerInfo();
        ClusterSyncInfo syncInfo = new ClusterSyncInfo();
        ConfigPlanExecutor executor = new ConfigPlanExecutor(nodeInfo, clusterSchemaInfo, partitionInfo, authorInfo, procedureInfo, udfInfo, triggerInfo, syncInfo);
        this.stateMachine = new PartitionRegionStateMachine(this, executor);
        this.nodeManager = new NodeManager(this, nodeInfo);
        this.clusterSchemaManager = new ClusterSchemaManager(this, clusterSchemaInfo);
        this.partitionManager = new PartitionManager(this, partitionInfo);
        this.permissionManager = new PermissionManager(this, authorInfo);
        this.procedureManager = new ProcedureManager(this, procedureInfo);
        this.udfManager = new UDFManager(this, udfInfo);
        this.triggerManager = new TriggerManager(this, triggerInfo);
        this.loadManager = new LoadManager(this);
        this.syncManager = new SyncManager(this, syncInfo);
    }

    public void initConsensusManager() throws IOException {
        this.consensusManager = new ConsensusManager(this, this.stateMachine);
    }

    public void close() throws IOException {
        this.consensusManager.close();
        this.partitionManager.getRegionMaintainer().shutdown();
        this.procedureManager.shiftExecutor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet registerDataNode(RegisterDataNodePlan registerDataNodePlan) {
        DataNodeRegisterResp dataSet;
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.triggerManager.getTriggerInfo().acquireTriggerTableLock();
            try {
                dataSet = (DataNodeRegisterResp)this.nodeManager.registerDataNode(registerDataNodePlan);
                dataSet.setTemplateInfo(this.clusterSchemaManager.getAllTemplateSetInfo());
                dataSet.setTriggerInformation(this.triggerManager.getTriggerTable().getAllTriggerInformation());
            }
            finally {
                this.triggerManager.getTriggerInfo().releaseTriggerTableLock();
            }
        } else {
            dataSet = new DataNodeRegisterResp();
            dataSet.setStatus(status);
            dataSet.setConfigNodeList(this.nodeManager.getRegisteredConfigNodes());
        }
        return dataSet;
    }

    @Override
    public DataSet removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.removeDataNode(removeDataNodePlan);
        }
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TSStatus reportRegionMigrateResult(TRegionMigrateResultReportReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.procedureManager.reportRegionMigrateResult(req);
        }
        return status;
    }

    @Override
    public DataSet getDataNodeConfiguration(GetDataNodeConfigurationPlan getDataNodeConfigurationPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.getDataNodeConfiguration(getDataNodeConfigurationPlan);
        }
        DataNodeConfigurationResp dataSet = new DataNodeConfigurationResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TShowClusterResp showCluster() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<TConfigNodeLocation> configNodeLocations = this.getNodeManager().getRegisteredConfigNodes();
            configNodeLocations.sort(Comparator.comparingInt(TConfigNodeLocation::getConfigNodeId));
            List dataNodeInfoLocations = this.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).sorted(Comparator.comparingInt(TDataNodeLocation::getDataNodeId)).collect(Collectors.toList());
            HashMap nodeStatus = new HashMap();
            this.getNodeManager().getNodeCacheMap().forEach((nodeId, heartbeatCache) -> nodeStatus.put(nodeId, heartbeatCache.getNodeStatusWithReason()));
            return new TShowClusterResp(status, configNodeLocations, dataNodeInfoLocations, nodeStatus);
        }
        return new TShowClusterResp(status, new ArrayList(), new ArrayList(), new HashMap());
    }

    @Override
    public TSStatus setTTL(SetTTLPlan setTTLPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTTL(setTTLPlan);
        }
        return status;
    }

    @Override
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaReplicationFactor(setSchemaReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setDataReplicationFactor(setDataReplicationFactorPlan);
        }
        return status;
    }

    @Override
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTimePartitionInterval(setTimePartitionIntervalPlan);
        }
        return status;
    }

    @Override
    public DataSet countMatchedStorageGroups(CountStorageGroupPlan countStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        CountStorageGroupResp result = new CountStorageGroupResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.countMatchedStorageGroups(countStorageGroupPlan);
        }
        result.setStatus(status);
        return result;
    }

    @Override
    public DataSet getMatchedStorageGroupSchemas(GetStorageGroupPlan getStorageGroupReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getMatchedStorageGroupSchema(getStorageGroupReq);
        }
        StorageGroupSchemaResp dataSet = new StorageGroupSchemaResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TSStatus setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setStorageGroup(setStorageGroupPlan);
        }
        return status;
    }

    @Override
    public TSStatus deleteStorageGroups(List<String> deletedPaths) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            Map<String, TStorageGroupSchema> deleteStorageSchemaMap = this.getClusterSchemaManager().getMatchedStorageGroupSchemasByName(deletedPaths);
            if (deleteStorageSchemaMap.isEmpty()) {
                return RpcUtils.getStatus((int)TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode(), (String)String.format("Path %s does not exist", Arrays.toString(deletedPaths.toArray())));
            }
            ArrayList<TStorageGroupSchema> parsedDeleteStorageGroups = new ArrayList<TStorageGroupSchema>(deleteStorageSchemaMap.values());
            return this.procedureManager.deleteStorageGroups(parsedDeleteStorageGroups);
        }
        return status;
    }

    private List<TSeriesPartitionSlot> calculateRelatedSlot(PartialPath path, PartialPath storageGroup) {
        if (path.getFullPath().contains("**")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        PartialPath innerPath = (PartialPath)path.alterPrefixPath(storageGroup).get(0);
        if (innerPath.getDevice().contains("*")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        return Collections.singletonList(this.getPartitionManager().getSeriesPartitionSlot(innerPath.getDevice()));
    }

    @Override
    public TSchemaPartitionTableResp getSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        HashMap<String, Set> partitionSlotsMap = new HashMap<String, Set>();
        List relatedPaths = patternTree.getAllPathPatterns();
        List<String> allStorageGroups = this.getClusterSchemaManager().getStorageGroupNames();
        HashMap<String, Boolean> scanAllRegions = new HashMap<String, Boolean>();
        for (PartialPath path : relatedPaths) {
            for (String storageGroup : allStorageGroups) {
                try {
                    PartialPath storageGroupPath = new PartialPath(storageGroup);
                    if (!path.overlapWith(storageGroupPath.concatNode("**")) || scanAllRegions.containsKey(storageGroup)) continue;
                    List<TSeriesPartitionSlot> relatedSlot = this.calculateRelatedSlot(path, storageGroupPath);
                    if (relatedSlot.isEmpty()) {
                        scanAllRegions.put(storageGroup, true);
                        partitionSlotsMap.put(storageGroup, new HashSet());
                        continue;
                    }
                    partitionSlotsMap.computeIfAbsent(storageGroup, k -> new HashSet()).addAll(relatedSlot);
                }
                catch (IllegalPathException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        if (partitionSlotsMap.isEmpty()) {
            return resp.setStatus(StatusUtils.OK).setSchemaPartitionTable(new HashMap());
        }
        GetSchemaPartitionPlan getSchemaPartitionPlan = new GetSchemaPartitionPlan(partitionSlotsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
        SchemaPartitionResp queryResult = (SchemaPartitionResp)this.partitionManager.getSchemaPartition(getSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        LOGGER.info("GetSchemaPartition receive paths: {}, return: {}", (Object)relatedPaths, (Object)resp);
        return resp;
    }

    @Override
    public TSchemaPartitionTableResp getOrCreateSchemaPartition(PathPatternTree patternTree) {
        TSchemaPartitionTableResp resp = new TSchemaPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        List devicePaths = patternTree.getAllDevicePatterns();
        List<String> storageGroups = this.getClusterSchemaManager().getStorageGroupNames();
        HashMap<String, List<TSeriesPartitionSlot>> partitionSlotsMap = new HashMap<String, List<TSeriesPartitionSlot>>();
        block0: for (String devicePath : devicePaths) {
            if (devicePath.contains("*")) continue;
            for (String storageGroup : storageGroups) {
                if (!PathUtils.isStartWith((String)devicePath, (String)storageGroup)) continue;
                partitionSlotsMap.computeIfAbsent(storageGroup, key -> new ArrayList()).add(this.getPartitionManager().getSeriesPartitionSlot(devicePath));
                continue block0;
            }
        }
        GetOrCreateSchemaPartitionPlan getOrCreateSchemaPartitionPlan = new GetOrCreateSchemaPartitionPlan(partitionSlotsMap);
        SchemaPartitionResp queryResult = this.partitionManager.getOrCreateSchemaPartition(getOrCreateSchemaPartitionPlan);
        resp = queryResult.convertToRpcSchemaPartitionTableResp();
        LOGGER.info("GetOrCreateSchemaPartition receive devicePaths: {}, return TSchemaPartitionResp: {}", (Object)devicePaths, (Object)resp);
        return resp;
    }

    @Override
    public TSchemaNodeManagementResp getNodePathsPartition(PartialPath partialPath, Integer level) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            GetNodePathsPartitionPlan getNodePathsPartitionPlan = new GetNodePathsPartitionPlan();
            getNodePathsPartitionPlan.setPartialPath(partialPath);
            if (null != level) {
                getNodePathsPartitionPlan.setLevel(level);
            }
            SchemaNodeManagementResp resp = this.partitionManager.getNodePathsPartition(getNodePathsPartitionPlan);
            TSchemaNodeManagementResp result = resp.convertToRpcSchemaNodeManagementPartitionResp(this.getLoadManager().genLatestRegionRouteMap());
            LOGGER.info("getNodePathsPartition receive devicePaths: {}, level: {}, return TSchemaNodeManagementResp: {}", new Object[]{partialPath, level, result});
            return result;
        }
        return new TSchemaNodeManagementResp().setStatus(status);
    }

    @Override
    public TDataPartitionTableResp getDataPartition(GetDataPartitionPlan getDataPartitionPlan) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = (DataPartitionResp)this.partitionManager.getDataPartition(getDataPartitionPlan);
        resp = queryResult.convertToTDataPartitionTableResp();
        LOGGER.info("GetDataPartition interface receive PartitionSlotsMap: {}, return: {}", getDataPartitionPlan.getPartitionSlotsMap(), (Object)resp);
        return resp;
    }

    @Override
    public TDataPartitionTableResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan getOrCreateDataPartitionReq) {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        TSStatus status = this.confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setStatus(status);
        }
        DataPartitionResp queryResult = this.partitionManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
        resp = queryResult.convertToTDataPartitionTableResp();
        LOGGER.info("GetOrCreateDataPartition success. receive PartitionSlotsMap: {}, return: {}", getOrCreateDataPartitionReq.getPartitionSlotsMap(), (Object)resp);
        return resp;
    }

    private TSStatus confirmLeader() {
        return this.getConsensusManager().confirmLeader();
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public ClusterSchemaManager getClusterSchemaManager() {
        return this.clusterSchemaManager;
    }

    @Override
    public ConsensusManager getConsensusManager() {
        return this.consensusManager;
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public LoadManager getLoadManager() {
        return this.loadManager;
    }

    @Override
    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public SyncManager getSyncManager() {
        return this.syncManager;
    }

    @Override
    public TSStatus operatePermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.operatePermission(authorPlan);
        }
        return status;
    }

    @Override
    public DataSet queryPermission(AuthorPlan authorPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.queryPermission(authorPlan);
        }
        PermissionInfoResp dataSet = new PermissionInfoResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TPermissionInfoResp login(String username, String password) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.login(username, password);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.checkUserPrivileges(username, paths, permission);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        return this.nodeManager.registerConfigNode(req);
    }

    @Override
    public TSStatus checkConfigNodeGlobalConfig(TConfigNodeRegisterReq req) {
        String errorPrefix = "Reject register, please ensure that the parameter ";
        String errorSuffix = " is consistent with the Seed-ConfigNode.";
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TSStatus errorStatus = new TSStatus(TSStatusCode.ERROR_GLOBAL_CONFIG.getStatusCode());
        if (!req.getDataRegionConsensusProtocolClass().equals(conf.getDataRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (!req.getSchemaRegionConsensusProtocolClass().equals(conf.getSchemaRegionConsensusProtocolClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_consensus_protocol_class is consistent with the Seed-ConfigNode.");
        }
        if (req.getSeriesPartitionSlotNum() != conf.getSeriesPartitionSlotNum()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_partition_slot_num is consistent with the Seed-ConfigNode.");
        }
        if (!req.getSeriesPartitionExecutorClass().equals(conf.getSeriesPartitionExecutorClass())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter series_partition_executor_class is consistent with the Seed-ConfigNode.");
        }
        if (req.getDefaultTTL() != CommonDescriptor.getInstance().getConfig().getDefaultTTL()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter default_ttl is consistent with the Seed-ConfigNode.");
        }
        if (req.getTimePartitionInterval() != conf.getTimePartitionInterval()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter time_partition_interval_for_routing is consistent with the Seed-ConfigNode.");
        }
        if (req.getSchemaReplicationFactor() != conf.getSchemaReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (req.getSchemaRegionPerDataNode() != conf.getSchemaRegionPerDataNode()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter schema_region_per_data_node is consistent with the Seed-ConfigNode.");
        }
        if (req.getDataReplicationFactor() != conf.getDataReplicationFactor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_replication_factor is consistent with the Seed-ConfigNode.");
        }
        if (req.getDataRegionPerProcessor() != conf.getDataRegionPerProcessor()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter data_region_per_processor is consistent with the Seed-ConfigNode.");
        }
        if (!req.getReadConsistencyLevel().equals(conf.getReadConsistencyLevel())) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter read_consistency_level is consistent with the Seed-ConfigNode.");
        }
        if (req.getDiskSpaceWarningThreshold() != CommonDescriptor.getInstance().getConfig().getDiskSpaceWarningThreshold()) {
            return errorStatus.setMessage("Reject register, please ensure that the parameter disk_space_warning_threshold is consistent with the Seed-ConfigNode.");
        }
        return null;
    }

    @Override
    public TSStatus createPeerForConsensusGroup(List<TConfigNodeLocation> configNodeLocations) {
        for (int i = 0; i < 30; ++i) {
            try {
                if (this.consensusManager != null) {
                    this.consensusManager.createPeerForConsensusGroup(configNodeLocations);
                    return StatusUtils.OK;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during retry creating peer for consensus group");
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed to create peer for consensus group", (Throwable)e);
                break;
            }
        }
        return StatusUtils.INTERNAL_ERROR;
    }

    @Override
    public TSStatus removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && (status = this.nodeManager.checkConfigNodeBeforeRemove(removeConfigNodePlan)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.procedureManager.removeConfigNode(removeConfigNodePlan);
        }
        return status;
    }

    @Override
    public TSStatus createFunction(String udfName, String className, List<String> uris) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.createFunction(udfName, className, uris) : status;
    }

    @Override
    public TSStatus dropFunction(String udfName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.dropFunction(udfName) : status;
    }

    @Override
    public TSStatus createTrigger(TCreateTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.createTrigger(req) : status;
    }

    @Override
    public TSStatus dropTrigger(TDropTriggerReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.dropTrigger(req) : status;
    }

    @Override
    public TGetTriggerTableResp getTriggerTable() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerTable() : new TGetTriggerTableResp(status, Collections.emptyList());
    }

    @Override
    public TGetTriggerJarResp getTriggerJar(TGetTriggerJarReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.triggerManager.getTriggerJar(req) : new TGetTriggerJarResp(status, Collections.emptyList());
    }

    @Override
    public TSStatus merge() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.merge()) : status;
    }

    @Override
    public TSStatus flush(TFlushReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.flush(req)) : status;
    }

    @Override
    public TSStatus clearCache() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.clearCache()) : status;
    }

    @Override
    public TSStatus loadConfiguration() {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.loadConfiguration()) : status;
    }

    @Override
    public TSStatus setSystemStatus(String systemStatus) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.setSystemStatus(systemStatus)) : status;
    }

    @Override
    public TRegionRouteMapResp getLatestRegionRouteMap() {
        TSStatus status = this.confirmLeader();
        TRegionRouteMapResp resp = new TRegionRouteMapResp(status);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setTimestamp(System.currentTimeMillis());
            resp.setRegionRouteMap(this.getLoadManager().genLatestRegionRouteMap());
        }
        return resp;
    }

    @Override
    public UDFManager getUDFManager() {
        return this.udfManager;
    }

    @Override
    public RegionInfoListResp showRegion(GetRegionInfoListPlan getRegionInfoListPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.partitionManager.getRegionInfoList(getRegionInfoListPlan);
        }
        RegionInfoListResp regionResp = new RegionInfoListResp();
        regionResp.setStatus(status);
        return regionResp;
    }

    @Override
    public TShowDataNodesResp showDataNodes() {
        TSStatus status = this.confirmLeader();
        TShowDataNodesResp resp = new TShowDataNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setDataNodesInfoList(this.nodeManager.getRegisteredDataNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowConfigNodesResp showConfigNodes() {
        TSStatus status = this.confirmLeader();
        TShowConfigNodesResp resp = new TShowConfigNodesResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.setConfigNodesInfoList(this.nodeManager.getRegisteredConfigNodeInfoList()).setStatus(StatusUtils.OK);
        }
        return resp.setStatus(status);
    }

    @Override
    public TShowStorageGroupResp showStorageGroup(GetStorageGroupPlan getStorageGroupPlan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.getClusterSchemaManager().showStorageGroup(getStorageGroupPlan);
        }
        return new TShowStorageGroupResp().setStatus(status);
    }

    @Override
    public ProcedureManager getProcedureManager() {
        return this.procedureManager;
    }

    public List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (this.clusterSchemaManager.getStorageGroupNames().contains(storageGroup.toString())) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }

    @Override
    public void addMetrics() {
        this.partitionManager.addMetrics();
        this.nodeManager.addMetrics();
    }

    @Override
    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            CreateSchemaTemplatePlan createSchemaTemplatePlan = new CreateSchemaTemplatePlan(req.getSerializedTemplate());
            return this.clusterSchemaManager.createTemplate(createSchemaTemplatePlan);
        }
        return status;
    }

    @Override
    public TGetAllTemplatesResp getAllTemplates() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getAllTemplates();
        }
        return new TGetAllTemplatesResp().setStatus(status);
    }

    @Override
    public TGetTemplateResp getTemplate(String req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getTemplate(req);
        }
        return new TGetTemplateResp().setStatus(status);
    }

    @Override
    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaTemplate(req.getName(), req.getPath());
        }
        return status;
    }

    @Override
    public TGetPathsSetTemplatesResp getPathsSetTemplate(String req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getPathsSetTemplate(req);
        }
        return new TGetPathsSetTemplatesResp(status);
    }

    @Override
    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.deleteTimeSeries(req);
        }
        return status;
    }

    @Override
    public TSStatus createPipeSink(CreatePipeSinkPlan plan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.createPipeSink(plan);
        }
        return status;
    }

    @Override
    public TSStatus dropPipeSink(DropPipeSinkPlan plan) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.dropPipeSink(plan);
        }
        return status;
    }

    @Override
    public TGetPipeSinkResp getPipeSink(TGetPipeSinkReq req) {
        TSStatus status = this.confirmLeader();
        TGetPipeSinkResp resp = new TGetPipeSinkResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.getPipeSink(req.getPipeSinkName());
        }
        return resp.setStatus(status);
    }

    @Override
    public TSStatus createPipe(TPipeInfo pipeInfo) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.createPipe(pipeInfo);
        }
        return status;
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.startPipe(pipeName);
        }
        return status;
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.stopPipe(pipeName);
        }
        return status;
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.procedureManager.dropPipe(pipeName);
        }
        return status;
    }

    @Override
    public TShowPipeResp showPipe(TShowPipeReq req) {
        TSStatus status = this.confirmLeader();
        TShowPipeResp resp = new TShowPipeResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.syncManager.showPipe(req.getPipeName());
        }
        return resp.setStatus(status);
    }

    @Override
    public TGetRoutingResp getRouting(GetRoutingPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getRouting(plan).convertToRpcGetRoutingResp() : new TGetRoutingResp(status);
    }

    @Override
    public TGetTimeSlotListResp getTimeSlotList(GetTimeSlotListPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getTimeSlotList(plan).convertToRpcGetTimeSlotListResp() : new TGetTimeSlotListResp(status);
    }

    @Override
    public TGetSeriesSlotListResp getSeriesSlotList(GetSeriesSlotListPlan plan) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.partitionManager.getSeriesSlotList(plan).convertToRpcGetSeriesSlotListResp() : new TGetSeriesSlotListResp(status);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedSchemaRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = schemaPartitionTable.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRelatedDataRegionGroup(PathPatternTree patternTree) {
        Map schemaPartitionTable = this.getSchemaPartition(patternTree).getSchemaPartitionTable();
        HashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> partitionSlotsMap = new HashMap<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>>();
        schemaPartitionTable.forEach((key, value) -> {
            HashMap slotListMap = new HashMap();
            value.keySet().forEach(slot -> slotListMap.put(slot, Collections.emptyList()));
            partitionSlotsMap.put((String)key, slotListMap);
        });
        GetDataPartitionPlan getDataPartitionPlan = new GetDataPartitionPlan(partitionSlotsMap);
        Map dataPartitionTable = this.getDataPartition(getDataPartitionPlan).getDataPartitionTable();
        List<TRegionReplicaSet> allRegionReplicaSets = this.getPartitionManager().getAllReplicaSets();
        Set groupIdSet = dataPartitionTable.values().stream().flatMap(tSeriesPartitionSlotMapMap -> tSeriesPartitionSlotMapMap.values().stream().flatMap(tTimePartitionSlotListMap -> tTimePartitionSlotListMap.values().stream().flatMap(Collection::stream))).collect(Collectors.toSet());
        HashMap<TConsensusGroupId, TRegionReplicaSet> filteredRegionReplicaSets = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (TRegionReplicaSet regionReplicaSet : allRegionReplicaSets) {
            if (!groupIdSet.contains(regionReplicaSet.getRegionId())) continue;
            filteredRegionReplicaSets.put(regionReplicaSet.getRegionId(), regionReplicaSet);
        }
        return filteredRegionReplicaSets;
    }

    public TConfigNodeLocation getConfigNodeLocation(int nodeId) {
        List<TConfigNodeLocation> configNodeLocations = this.nodeManager.getRegisteredConfigNodes();
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            if (configNodeLocation.getConfigNodeId() != nodeId) continue;
            return configNodeLocation;
        }
        return null;
    }
}

