/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class CreateDataPartitionPlan
extends ConfigPhysicalPlan {
    private Map<String, DataPartitionTable> assignedDataPartition;

    public CreateDataPartitionPlan() {
        super(ConfigPhysicalPlanType.CreateDataPartition);
    }

    public Map<String, DataPartitionTable> getAssignedDataPartition() {
        return this.assignedDataPartition;
    }

    public void setAssignedDataPartition(Map<String, DataPartitionTable> assignedDataPartition) {
        this.assignedDataPartition = assignedDataPartition;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        try {
            TIOStreamTransport transport = new TIOStreamTransport((OutputStream)stream);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            stream.writeInt(ConfigPhysicalPlanType.CreateDataPartition.ordinal());
            stream.writeInt(this.assignedDataPartition.size());
            for (Map.Entry<String, DataPartitionTable> dataPartitionTableEntry : this.assignedDataPartition.entrySet()) {
                BasicStructureSerDeUtil.write((String)dataPartitionTableEntry.getKey(), (DataOutputStream)stream);
                dataPartitionTableEntry.getValue().serialize((OutputStream)stream, (TProtocol)protocol);
            }
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.assignedDataPartition = new HashMap<String, DataPartitionTable>();
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            DataPartitionTable dataPartitionTable = new DataPartitionTable();
            dataPartitionTable.deserialize(buffer);
            this.assignedDataPartition.put(storageGroup, dataPartitionTable);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDataPartitionPlan that = (CreateDataPartitionPlan)o;
        return this.assignedDataPartition.equals(that.assignedDataPartition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assignedDataPartition);
    }
}

