/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesUtils.class);
    private static final File systemPropertiesFile = new File(ConfigNodeDescriptor.getInstance().getConf().getSystemDir() + File.separator + "confignode-system.properties");
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();

    public static boolean isRestarted() {
        return systemPropertiesFile.exists();
    }

    public static void checkSystemProperties() throws IOException, ConfigurationException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        boolean needReWrite = false;
        String internalAddress = systemProperties.getProperty("internal_address", null);
        if (internalAddress == null) {
            needReWrite = true;
        } else if (!internalAddress.equals(conf.getInternalAddress())) {
            throw new ConfigurationException("internal_address", conf.getInternalAddress(), internalAddress);
        }
        if (systemProperties.getProperty("internal_port", null) == null) {
            needReWrite = true;
        } else {
            int internalPort = Integer.parseInt(systemProperties.getProperty("internal_port"));
            if (internalPort != conf.getInternalPort()) {
                throw new ConfigurationException("internal_port", String.valueOf(conf.getInternalPort()), String.valueOf(internalPort));
            }
        }
        if (systemProperties.getProperty("consensus_port", null) == null) {
            needReWrite = true;
        } else {
            int consensusPort = Integer.parseInt(systemProperties.getProperty("consensus_port"));
            if (consensusPort != conf.getConsensusPort()) {
                throw new ConfigurationException("consensus_port", String.valueOf(conf.getConsensusPort()), String.valueOf(consensusPort));
            }
        }
        String configNodeConsensusProtocolClass = systemProperties.getProperty("config_node_consensus_protocol_class", null);
        if (configNodeConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!configNodeConsensusProtocolClass.equals(conf.getConfigNodeConsensusProtocolClass())) {
            throw new ConfigurationException("config_node_consensus_protocol_class", conf.getConfigNodeConsensusProtocolClass(), configNodeConsensusProtocolClass);
        }
        String dataRegionConsensusProtocolClass = systemProperties.getProperty("data_region_consensus_protocol_class", null);
        if (dataRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!dataRegionConsensusProtocolClass.equals(conf.getDataRegionConsensusProtocolClass())) {
            throw new ConfigurationException("data_region_consensus_protocol_class", conf.getDataRegionConsensusProtocolClass(), dataRegionConsensusProtocolClass);
        }
        String schemaRegionConsensusProtocolClass = systemProperties.getProperty("schema_region_consensus_protocol_class", null);
        if (schemaRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!schemaRegionConsensusProtocolClass.equals(conf.getSchemaRegionConsensusProtocolClass())) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", conf.getSchemaRegionConsensusProtocolClass(), schemaRegionConsensusProtocolClass);
        }
        if (systemProperties.getProperty("series_partition_slot_num", null) == null) {
            needReWrite = true;
        } else {
            int seriesPartitionSlotNum = Integer.parseInt(systemProperties.getProperty("series_partition_slot_num"));
            if (seriesPartitionSlotNum != conf.getSeriesPartitionSlotNum()) {
                throw new ConfigurationException("series_partition_slot_num", String.valueOf(conf.getSeriesPartitionSlotNum()), String.valueOf(seriesPartitionSlotNum));
            }
        }
        String seriesPartitionSlotExecutorClass = systemProperties.getProperty("series_partition_executor_class", null);
        if (seriesPartitionSlotExecutorClass == null) {
            needReWrite = true;
        } else if (!Objects.equals(seriesPartitionSlotExecutorClass, conf.getSeriesPartitionExecutorClass())) {
            throw new ConfigurationException("series_partition_executor_class", conf.getSeriesPartitionExecutorClass(), seriesPartitionSlotExecutorClass);
        }
        if (needReWrite) {
            SystemPropertiesUtils.storeSystemParameters();
        }
    }

    public static List<TConfigNodeLocation> loadConfigNodeList() throws IOException, BadNodeUrlException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        String addresses = systemProperties.getProperty("config_node_list", null);
        if (addresses != null && !addresses.isEmpty()) {
            return NodeUrlUtils.parseTConfigNodeUrls((String)addresses);
        }
        return new ArrayList<TConfigNodeLocation>();
    }

    public static void storeSystemParameters() throws IOException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        systemProperties.setProperty("internal_address", String.valueOf(conf.getInternalAddress()));
        systemProperties.setProperty("internal_port", String.valueOf(conf.getInternalPort()));
        systemProperties.setProperty("consensus_port", String.valueOf(conf.getConsensusPort()));
        systemProperties.setProperty("config_node_consensus_protocol_class", conf.getConfigNodeConsensusProtocolClass());
        systemProperties.setProperty("data_region_consensus_protocol_class", conf.getDataRegionConsensusProtocolClass());
        systemProperties.setProperty("schema_region_consensus_protocol_class", conf.getSchemaRegionConsensusProtocolClass());
        systemProperties.setProperty("series_partition_slot_num", String.valueOf(conf.getSeriesPartitionSlotNum()));
        systemProperties.setProperty("series_partition_executor_class", conf.getSeriesPartitionExecutorClass());
        SystemPropertiesUtils.storeSystemProperties(systemProperties);
    }

    public static void storeConfigNodeList(List<TConfigNodeLocation> configNodes) throws IOException {
        if (!systemPropertiesFile.exists()) {
            return;
        }
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        systemProperties.setProperty("config_node_list", NodeUrlUtils.convertTConfigNodeUrls(configNodes));
        SystemPropertiesUtils.storeSystemProperties(systemProperties);
    }

    public static void storeConfigNodeId(int nodeId) throws IOException {
        if (!systemPropertiesFile.exists()) {
            return;
        }
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        systemProperties.setProperty("config_node_id", String.valueOf(nodeId));
        SystemPropertiesUtils.storeSystemProperties(systemProperties);
    }

    private static synchronized Properties getSystemProperties() throws IOException {
        if (!systemPropertiesFile.exists()) {
            if (systemPropertiesFile.createNewFile()) {
                LOGGER.info("System properties file {} for ConfigNode is created.", (Object)systemPropertiesFile.getAbsolutePath());
            } else {
                LOGGER.error("Can't create the system properties file {} for ConfigNode. IoTDB-ConfigNode is shutdown.", (Object)systemPropertiesFile.getAbsolutePath());
                throw new IOException("Can't create system properties file");
            }
        }
        Properties systemProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(systemPropertiesFile);){
            systemProperties.load(inputStream);
        }
        return systemProperties;
    }

    private static synchronized void storeSystemProperties(Properties systemProperties) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(systemPropertiesFile);){
            systemProperties.store(fileOutputStream, "");
        }
    }
}

