/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.sync;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TDisableDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataNodeClientPool.class);
    private static final int retryNum = 6;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());

    private SyncDataNodeClientPool() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSStatus sendSyncRequestToDataNodeWithRetry(TEndPoint endPoint, Object req, DataNodeRequestType requestType) {
        Throwable lastException = null;
        int retry = 0;
        while (true) {
            if (retry >= 6) {
                LOGGER.error("{} failed on DataNode {}", new Object[]{requestType, endPoint, lastException});
                return new TSStatus(TSStatusCode.ALL_RETRY_FAILED.getStatusCode()).setMessage("All retry failed due to: " + lastException.getMessage());
            }
            try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);){
                switch (requestType) {
                    case INVALIDATE_PARTITION_CACHE: {
                        TSStatus tSStatus = client.invalidatePartitionCache((TInvalidateCacheReq)req);
                        return tSStatus;
                    }
                    case INVALIDATE_SCHEMA_CACHE: {
                        TSStatus tSStatus = client.invalidateSchemaCache((TInvalidateCacheReq)req);
                        return tSStatus;
                    }
                    case CREATE_SCHEMA_REGION: {
                        TSStatus tSStatus = client.createSchemaRegion((TCreateSchemaRegionReq)req);
                        return tSStatus;
                    }
                    case CREATE_DATA_REGION: {
                        TSStatus tSStatus = client.createDataRegion((TCreateDataRegionReq)req);
                        return tSStatus;
                    }
                    case DELETE_REGION: {
                        TSStatus tSStatus = client.deleteRegion((TConsensusGroupId)req);
                        return tSStatus;
                    }
                    case INVALIDATE_PERMISSION_CACHE: {
                        TSStatus tSStatus = client.invalidatePermissionCache((TInvalidatePermissionCacheReq)req);
                        return tSStatus;
                    }
                    case DISABLE_DATA_NODE: {
                        TSStatus tSStatus = client.disableDataNode((TDisableDataNodeReq)req);
                        return tSStatus;
                    }
                    case STOP_DATA_NODE: {
                        TSStatus tSStatus = client.stopDataNode();
                        return tSStatus;
                    }
                    case SET_SYSTEM_STATUS: {
                        TSStatus tSStatus = client.setSystemStatus((String)req);
                        return tSStatus;
                    }
                    case UPDATE_TEMPLATE: {
                        TSStatus tSStatus = client.updateTemplate((TUpdateTemplateReq)req);
                        return tSStatus;
                    }
                    case CREATE_NEW_REGION_PEER: {
                        TSStatus tSStatus = client.createNewRegionPeer((TCreatePeerReq)req);
                        return tSStatus;
                    }
                    case ADD_REGION_PEER: {
                        TSStatus tSStatus = client.addRegionPeer((TMaintainPeerReq)req);
                        return tSStatus;
                    }
                    case REMOVE_REGION_PEER: {
                        TSStatus tSStatus = client.removeRegionPeer((TMaintainPeerReq)req);
                        return tSStatus;
                    }
                    case DELETE_OLD_REGION_PEER: {
                        TSStatus tSStatus = client.deleteOldRegionPeer((TMaintainPeerReq)req);
                        return tSStatus;
                    }
                }
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Unknown request type: " + (Object)((Object)requestType)));
                return tSStatus;
            }
            catch (IOException | TException e) {
                lastException = e;
                LOGGER.warn("{} failed on DataNode {}, because {}, retrying {}...", new Object[]{requestType, endPoint, e.getMessage(), retry});
                this.doRetryWait(retry);
                ++retry;
                continue;
            }
            break;
        }
    }

    private void doRetryWait(int retryNum) {
        try {
            TimeUnit.MILLISECONDS.sleep(100L * (long)Math.pow(2.0, retryNum));
        }
        catch (InterruptedException e) {
            LOGGER.error("Retry wait failed.", (Throwable)e);
        }
    }

    public TSStatus changeRegionLeader(TConsensusGroupId regionId, TEndPoint dataNode, TDataNodeLocation newLeaderNode) {
        TSStatus status;
        LOGGER.info("send RPC to data node: {} for changing regions leader on it", (Object)dataNode);
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)dataNode);){
            TRegionLeaderChangeReq req = new TRegionLeaderChangeReq(regionId, newLeaderNode);
            status = client.changeRegionLeader(req);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to Data node: {}", (Object)dataNode, (Object)e);
            status = new TSStatus(TSStatusCode.NO_CONNECTION.getStatusCode());
            status.setMessage(e.getMessage());
        }
        catch (TException e) {
            LOGGER.error("Change regions leader error on Date node: {}", (Object)dataNode, (Object)e);
            status = new TSStatus(TSStatusCode.REGION_LEADER_CHANGE_FAILED.getStatusCode());
            status.setMessage(e.getMessage());
        }
        return status;
    }

    public static SyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final SyncDataNodeClientPool INSTANCE = new SyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

