/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.executor;

import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.exception.TriggerExecutionException;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;

public class TriggerExecutor {
    private final TriggerInformation triggerInformation;
    private final Trigger trigger;

    public TriggerExecutor(TriggerInformation triggerInformation, Trigger trigger) {
        this.triggerInformation = triggerInformation;
        this.trigger = trigger;
        this.onCreate();
    }

    private void onCreate() {
        try {
            TriggerAttributes attributes = new TriggerAttributes(this.triggerInformation.getAttributes());
            this.trigger.validate(attributes);
            this.trigger.onCreate(attributes);
        }
        catch (Exception e) {
            this.onTriggerExecutionError("validate/onCreate(TriggerAttributes)", e);
        }
    }

    public void onDrop() {
        try {
            this.trigger.onDrop();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("drop", e);
        }
    }

    private void onTriggerExecutionError(String methodName, Exception e) throws TriggerExecutionException {
        throw new TriggerExecutionException(String.format("Error occurred during executing Trigger#%s: %s", methodName, System.lineSeparator()) + e);
    }

    public TriggerInformation getTriggerInformation() {
        return this.triggerInformation;
    }
}

