/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.sync.pipesink.IoTDBPipeSink;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.db.sync.transport.client.IoTDBSyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SyncClientFactory.class);

    public static ISyncClient createSyncClient(Pipe pipe, PipeSink pipeSink, String dataRegionId) {
        DataRegion dataRegion = StorageEngineV2.getInstance().getDataRegion(new DataRegionId(Integer.parseInt(dataRegionId)));
        switch (pipeSink.getType()) {
            case IoTDB: {
                IoTDBPipeSink ioTDBPipeSink = (IoTDBPipeSink)pipeSink;
                return new IoTDBSyncClient(pipe, ioTDBPipeSink.getIp(), ioTDBPipeSink.getPort(), SyncClientFactory.getLocalIP(ioTDBPipeSink), dataRegion.getStorageGroupName());
            }
        }
        throw new UnsupportedOperationException();
    }

    private static String getLocalIP(IoTDBPipeSink pipeSink) {
        String localIP;
        block8: {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                if (inetAddress.isLoopbackAddress()) {
                    try (DatagramSocket socket = new DatagramSocket();){
                        socket.connect(InetAddress.getByName(pipeSink.getIp()), pipeSink.getPort());
                        localIP = socket.getLocalAddress().getHostAddress();
                        break block8;
                    }
                }
                localIP = inetAddress.getHostAddress();
            }
            catch (SocketException | UnknownHostException e) {
                logger.error("Get local host error when create transport handler.", (Throwable)e);
                localIP = "UNKNOWN IP";
            }
        }
        return localIP;
    }
}

