/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncConstant;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.db.sync.transport.client.SyncClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger logger = LoggerFactory.getLogger(SenderManager.class);
    private final Map<String, ISyncClient> clientMap;
    private final Map<String, Future> transportFutureMap;
    private final Pipe pipe;
    private final PipeSink pipeSink;
    protected ExecutorService transportExecutorService;
    private boolean isRunning;

    public SenderManager(Pipe pipe, PipeSink pipeSink) {
        this.pipe = pipe;
        this.pipeSink = pipeSink;
        this.transportExecutorService = IoTDBThreadPoolFactory.newCachedThreadPool((String)(ThreadName.SYNC_SENDER_PIPE.getName() + "-" + pipe.getName()));
        this.clientMap = new HashMap<String, ISyncClient>();
        this.transportFutureMap = new HashMap<String, Future>();
        this.isRunning = false;
    }

    public void start() {
        for (Map.Entry<String, ISyncClient> entry : this.clientMap.entrySet()) {
            String dataRegionId = entry.getKey();
            ISyncClient syncClient = entry.getValue();
            this.transportFutureMap.put(dataRegionId, this.transportExecutorService.submit(() -> this.takePipeDataAndTransport(syncClient, dataRegionId)));
        }
        this.isRunning = true;
    }

    public void stop() {
        for (Future future : this.transportFutureMap.values()) {
            future.cancel(true);
        }
        this.isRunning = false;
    }

    public void close() throws PipeException {
        try {
            this.transportExecutorService.shutdownNow();
            boolean isClosed = this.transportExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS);
            if (!isClosed) {
                throw new PipeException(String.format("Close SenderManager of Pipe %s error after %s %s, please try again.", this.pipe.getName(), SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS.name()));
            }
        }
        catch (InterruptedException e) {
            throw new PipeException(String.format("Interrupted when waiting for clear SenderManager of Pipe %s.", this.pipe.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takePipeDataAndTransport(ISyncClient syncClient, String dataRegionId) {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!syncClient.handshake()) {
                        SyncService.getInstance().recordMessage(new PipeMessage(PipeMessage.PipeMessageType.ERROR, String.format("Can not handshake with %s", this.pipeSink)));
                    }
                    while (!Thread.currentThread().isInterrupted()) {
                        PipeData pipeData = this.pipe.take(dataRegionId);
                        if (!syncClient.send(pipeData)) {
                            logger.error(String.format("Can not transfer pipedata %s, skip it.", pipeData));
                            SyncService.getInstance().recordMessage(new PipeMessage(PipeMessage.PipeMessageType.WARN, String.format("Transfer piepdata %s error, skip it.", pipeData.getSerialNumber())));
                        }
                        this.pipe.commit(dataRegionId);
                    }
                }
                catch (SyncConnectionException e) {
                    logger.error(String.format("Connect to receiver %s error, because %s.", new Object[]{this.pipeSink, e}));
                }
            }
        }
        catch (InterruptedException e) {
            logger.info("Interrupted by pipe, exit transport.");
        }
        finally {
            syncClient.close();
        }
    }

    public void registerDataRegion(String dataRegionId) {
        ISyncClient syncClient = SyncClientFactory.createSyncClient(this.pipe, this.pipeSink, dataRegionId);
        this.clientMap.put(dataRegionId, syncClient);
        if (this.isRunning) {
            this.transportFutureMap.put(dataRegionId, this.transportExecutorService.submit(() -> this.takePipeDataAndTransport(syncClient, dataRegionId)));
        }
    }

    public void unregisterDataRegion(String dataRegionId) {
        Future future = this.transportFutureMap.remove(dataRegionId);
        if (future != null) {
            future.cancel(true);
            this.clientMap.remove(dataRegionId);
        }
    }

    public void setSyncClient(ISyncClient syncClient) {
    }
}

