/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.common;

import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSyncInfoFetcher
implements ISyncInfoFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSyncInfoFetcher.class);
    private static final IClientManager<PartitionRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    @Override
    public TSStatus addPipeSink(CreatePipeSinkPlan plan) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public TSStatus addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public TSStatus dropPipeSink(String name) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public PipeSink getPipeSink(String name) throws PipeSinkException {
        ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);
        try {
            TGetPipeSinkReq tGetPipeSinkReq = new TGetPipeSinkReq().setPipeSinkName(name);
            TGetPipeSinkResp resp = configNodeClient.getPipeSink(tGetPipeSinkReq);
            if (resp.getPipeSinkInfoList().isEmpty()) {
                throw new PipeSinkException(String.format("Failed to getPipeSink [%s] because it does not exist.", name));
            }
            PipeSink pipeSink = SyncPipeUtil.parseTPipeSinkInfoAsPipeSink((TPipeSinkInfo)resp.getPipeSinkInfoList().get(0));
            if (configNodeClient != null) {
                configNodeClient.close();
            }
            return pipeSink;
        }
        catch (Throwable throwable) {
            try {
                if (configNodeClient != null) {
                    try {
                        configNodeClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Get PipeSink [{}] error because {}", new Object[]{name, e.getMessage(), e});
                throw new PipeSinkException(e.getMessage());
            }
        }
    }

    @Override
    public List<PipeSink> getAllPipeSinks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TSStatus addPipe(PipeInfo pipeInfo) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public TSStatus stopPipe(String pipeName) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public TSStatus startPipe(String pipeName) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public TSStatus dropPipe(String pipeName) {
        return RpcUtils.SUCCESS_STATUS;
    }

    @Override
    public List<PipeInfo> getAllPipeInfos() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PipeInfo getRunningPipeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TSStatus recordMsg(String pipeName, long createTime, PipeMessage message) {
        return null;
    }

    public static ClusterSyncInfoFetcher getInstance() {
        return ClusterSyncInfoFetcherHolder.INSTANCE;
    }

    private static class ClusterSyncInfoFetcherHolder {
        private static final ClusterSyncInfoFetcher INSTANCE = new ClusterSyncInfoFetcher();

        private ClusterSyncInfoFetcherHolder() {
        }
    }
}

