/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.influxdb.dto.IoTDBPoint;
import org.apache.iotdb.db.protocol.influxdb.handler.AbstractQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.handler.QueryHandler;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineParser;
import org.apache.iotdb.db.protocol.influxdb.meta.AbstractInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.sql.InfluxDBLogicalGenerator;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.thrift.impl.IInfluxDBServiceWithHandler;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxCloseSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxCreateDatabaseReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxOpenSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxOpenSessionResp;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryResultRsp;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxTSStatus;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxWritePointsReq;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.Point;

public class InfluxDBServiceImpl
implements IInfluxDBServiceWithHandler {
    private final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final AbstractInfluxDBMetaManager metaManager = InfluxDBMetaManager.getInstance();
    private final AbstractQueryHandler queryHandler = new QueryHandler();

    public InfluxOpenSessionResp openSession(InfluxOpenSessionReq req) throws TException {
        BasicOpenSessionResp basicOpenSessionResp = this.SESSION_MANAGER.openSession(req.username, req.password, req.zoneId, TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3);
        return new InfluxOpenSessionResp().setStatus(RpcUtils.getInfluxDBStatus((int)basicOpenSessionResp.getCode(), (String)basicOpenSessionResp.getMessage())).setSessionId(basicOpenSessionResp.getSessionId());
    }

    public InfluxTSStatus closeSession(InfluxCloseSessionReq req) {
        return new InfluxTSStatus(!this.SESSION_MANAGER.closeSession(req.sessionId) ? RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public InfluxTSStatus writePoints(InfluxWritePointsReq req) {
        if (!this.SESSION_MANAGER.checkLogin(req.sessionId)) {
            return this.getNotLoggedInStatus();
        }
        ArrayList<InfluxTSStatus> tsStatusList = new ArrayList<InfluxTSStatus>();
        int executeCode = TSStatusCode.SUCCESS_STATUS.getStatusCode();
        for (Point point : InfluxLineParser.parserRecordsToPointsWithPrecision(req.lineProtocol, req.precision)) {
            IoTDBPoint iotdbPoint = new IoTDBPoint(req.database, point, this.metaManager, req.sessionId);
            try {
                InsertRowPlan plan = iotdbPoint.convertToInsertRowPlan();
                InfluxTSStatus tsStatus = this.executeNonQueryPlan(plan, req.sessionId);
                if (executeCode == TSStatusCode.SUCCESS_STATUS.getStatusCode() && tsStatus.getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                    executeCode = tsStatus.getCode();
                }
                tsStatusList.add(tsStatus);
            }
            catch (IllegalPathException | StorageEngineException | StorageGroupNotSetException | QueryProcessException | IoTDBConnectionException e) {
                throw new InfluxDBException(((Throwable)e).getMessage());
            }
        }
        return new InfluxTSStatus().setCode(executeCode).setSubStatus(tsStatusList);
    }

    public InfluxTSStatus createDatabase(InfluxCreateDatabaseReq req) {
        if (!this.SESSION_MANAGER.checkLogin(req.sessionId)) {
            return this.getNotLoggedInStatus();
        }
        try {
            SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(new PartialPath("root." + req.getDatabase()));
            return this.executeNonQueryPlan(setStorageGroupPlan, req.getSessionId());
        }
        catch (IllegalPathException | StorageEngineException | StorageGroupNotSetException | QueryProcessException e) {
            if (e instanceof QueryProcessException && e.getErrorCode() == TSStatusCode.STORAGE_GROUP_ALREADY_EXISTS.getStatusCode()) {
                return RpcUtils.getInfluxDBStatus((int)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (String)"Execute successfully");
            }
            throw new InfluxDBException(e.getMessage());
        }
    }

    public InfluxQueryResultRsp query(InfluxQueryReq req) throws TException {
        Operator operator = InfluxDBLogicalGenerator.generate(req.command);
        this.queryHandler.checkInfluxDBQueryOperator(operator);
        return this.queryHandler.queryInfluxDB(req.database, (InfluxQueryOperator)operator, req.sessionId, IoTDB.serviceProvider);
    }

    @Override
    public void handleClientExit() {
        Long sessionId = ServiceProvider.SESSION_MANAGER.getCurrSessionId();
        if (sessionId != null) {
            this.closeSession(new InfluxCloseSessionReq(sessionId.longValue()));
        }
    }

    private InfluxTSStatus getNotLoggedInStatus() {
        return RpcUtils.getInfluxDBStatus((int)TSStatusCode.NOT_LOGIN_ERROR.getStatusCode(), (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private InfluxTSStatus executeNonQueryPlan(PhysicalPlan plan, long sessionId) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        TSStatus status = this.SESSION_MANAGER.checkAuthority(plan, sessionId);
        if (status == null) {
            status = IoTDB.serviceProvider.executeNonQuery(plan) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        return DataTypeUtils.RPCStatusToInfluxDBTSStatus(status);
    }
}

