/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.protocol.influxdb.constant.InfluxSQLConstant;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionFactory;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxSelector;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxSelectComponent;
import org.apache.iotdb.db.protocol.influxdb.util.FilterUtils;
import org.apache.iotdb.db.protocol.influxdb.util.JacksonUtils;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryResultRsp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.influxdb.dto.QueryResult;

public abstract class AbstractQueryHandler {
    abstract Map<String, Integer> getFieldOrders(String var1, String var2, ServiceProvider var3, long var4);

    abstract InfluxFunctionValue updateByIoTDBFunc(InfluxFunction var1, ServiceProvider var2, String var3, long var4);

    abstract QueryResult queryByConditions(String var1, String var2, String var3, ServiceProvider var4, Map<String, Integer> var5, long var6) throws AuthException;

    public final InfluxQueryResultRsp queryInfluxDB(String database, InfluxQueryOperator queryOperator, long sessionId, ServiceProvider serviceProvider) {
        String measurement = queryOperator.getFromComponent().getPrefixPaths().get(0).getFullPath();
        Map<String, Integer> fieldOrders = this.getFieldOrders(database, measurement, serviceProvider, sessionId);
        InfluxQueryResultRsp tsQueryResultRsp = new InfluxQueryResultRsp();
        try {
            QueryResult queryResult;
            if (queryOperator.getWhereComponent() != null || queryOperator.getSelectComponent().isHasCommonQuery() || queryOperator.getSelectComponent().isHasOnlyTraverseFunction()) {
                queryResult = this.queryExpr(queryOperator.getWhereComponent() != null ? queryOperator.getWhereComponent().getFilterOperator() : null, database, measurement, serviceProvider, fieldOrders, sessionId);
                this.ProcessSelectComponent(queryResult, queryOperator.getSelectComponent());
            } else {
                queryResult = this.queryFuncWithoutFilter(queryOperator.getSelectComponent(), database, measurement, serviceProvider, sessionId);
            }
            return tsQueryResultRsp.setResultJsonString(JacksonUtils.bean2Json(queryResult)).setStatus(RpcUtils.getInfluxDBStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (AuthException e) {
            return tsQueryResultRsp.setStatus(RpcUtils.getInfluxDBStatus((int)TSStatusCode.UNINITIALIZED_AUTH_ERROR.getStatusCode(), (String)e.getMessage()));
        }
    }

    public IExpression getIExpressionForBasicFunctionOperator(BasicFunctionOperator basicFunctionOperator) {
        return new SingleSeriesExpression((Path)basicFunctionOperator.getSinglePath(), FilterUtils.filterTypeToFilter(basicFunctionOperator.getFilterType(), basicFunctionOperator.getValue()));
    }

    public void ProcessSelectComponent(QueryResult queryResult, InfluxSelectComponent selectComponent) {
        List columns = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getColumns();
        HashMap<String, Integer> columnOrders = new HashMap<String, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            columnOrders.put((String)columns.get(i), i);
        }
        ArrayList values = ((QueryResult.Series)((QueryResult.Result)queryResult.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<String> newColumns = new ArrayList<String>();
        newColumns.add("time");
        if (selectComponent.isHasFunction()) {
            ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof FunctionExpression) {
                    String functionName = ((FunctionExpression)expression).getFunctionName();
                    functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
                    newColumns.add(functionName);
                    continue;
                }
                if (!(expression instanceof TimeSeriesOperand)) continue;
                String columnName = ((TimeSeriesOperand)expression).getPath().getFullPath();
                if (!columnName.equals("*")) {
                    newColumns.add(columnName);
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            for (List list : values) {
                for (InfluxFunction function : functions) {
                    List<Expression> expressions = function.getExpressions();
                    if (expressions == null) {
                        throw new IllegalArgumentException("not support param");
                    }
                    TimeSeriesOperand parmaExpression = (TimeSeriesOperand)expressions.get(0);
                    String parmaName = parmaExpression.getPath().getFullPath();
                    if (!columnOrders.containsKey(parmaName)) continue;
                    Object selectedValue = list.get((Integer)columnOrders.get(parmaName));
                    Long selectedTimestamp = (Long)list.get(0);
                    if (selectedValue == null) continue;
                    if (function instanceof InfluxSelector) {
                        ((InfluxSelector)function).updateValueAndRelateValues(new InfluxFunctionValue(selectedValue, selectedTimestamp), list);
                        continue;
                    }
                    ((InfluxAggregator)function).updateValueBruteForce(new InfluxFunctionValue(selectedValue, selectedTimestamp));
                }
            }
            ArrayList<Object> value = new ArrayList<Object>();
            values = new ArrayList();
            if (selectComponent.isHasCommonQuery()) {
                InfluxSelector influxSelector = (InfluxSelector)functions.get(0);
                List<Object> relatedValue = influxSelector.getRelatedValues();
                for (String column : newColumns) {
                    if (InfluxSQLConstant.getNativeSelectorFunctionNames().contains(column)) {
                        value.add(influxSelector.calculateBruteForce().getValue());
                        continue;
                    }
                    if (relatedValue == null) continue;
                    value.add(relatedValue.get((Integer)columnOrders.get(column)));
                }
            } else {
                for (InfluxFunction function : functions) {
                    if (value.size() == 0) {
                        value.add(function.calculateBruteForce().getTimestamp());
                    } else {
                        value.set(0, function.calculateBruteForce().getTimestamp());
                    }
                    value.add(function.calculateBruteForce().getValue());
                }
                if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
                    value.set(0, 0);
                }
            }
            values.add(value);
        } else if (selectComponent.isHasCommonQuery()) {
            for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                if (!(expression instanceof TimeSeriesOperand)) continue;
                if (!((TimeSeriesOperand)expression).getPath().getFullPath().equals("*")) {
                    newColumns.add(((TimeSeriesOperand)expression).getPath().getFullPath());
                    continue;
                }
                newColumns.addAll(columns.subList(1, columns.size()));
            }
            ArrayList newValues = new ArrayList();
            for (List list : values) {
                ArrayList tmpValue = new ArrayList();
                for (String newColumn : newColumns) {
                    tmpValue.add(list.get((Integer)columnOrders.get(newColumn)));
                }
                newValues.add(tmpValue);
            }
            values = newValues;
        }
        QueryResultUtils.updateQueryResultColumnValue(queryResult, StringUtils.removeDuplicate(newColumns), values);
    }

    public final QueryResult queryFuncWithoutFilter(InfluxSelectComponent selectComponent, String database, String measurement, ServiceProvider serviceProvider, long sessionid) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        ArrayList<InfluxFunction> functions = new ArrayList<InfluxFunction>();
        String path = "root." + database + "." + measurement;
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if (!(expression instanceof FunctionExpression)) continue;
            String functionName = ((FunctionExpression)expression).getFunctionName();
            functions.add(InfluxFunctionFactory.generateFunction(functionName, expression.getExpressions()));
            columns.add(functionName);
        }
        ArrayList<Object> value = new ArrayList<Object>();
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>();
        for (InfluxFunction function : functions) {
            InfluxFunctionValue functionValue = this.updateByIoTDBFunc(function, serviceProvider, path, sessionid);
            if (value.size() == 0) {
                value.add(functionValue.getTimestamp());
            } else {
                value.set(0, functionValue.getTimestamp());
            }
            value.add(functionValue.getValue());
        }
        if (selectComponent.isHasAggregationFunction() || selectComponent.isHasMoreFunction()) {
            value.set(0, 0);
        }
        values.add(value);
        QueryResult queryResult = new QueryResult();
        QueryResult.Series series = new QueryResult.Series();
        series.setColumns(columns);
        series.setValues(values);
        series.setName(measurement);
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    public QueryResult queryExpr(FilterOperator operator, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        if (operator == null) {
            ArrayList<IExpression> expressions = new ArrayList<IExpression>();
            return this.queryByConditions(expressions, database, measurement, serviceProvider, fieldOrders, sessionId);
        }
        if (operator instanceof BasicFunctionOperator) {
            ArrayList<IExpression> iExpressions = new ArrayList<IExpression>();
            iExpressions.add(this.getIExpressionForBasicFunctionOperator((BasicFunctionOperator)operator));
            return this.queryByConditions(iExpressions, database, measurement, serviceProvider, fieldOrders, sessionId);
        }
        FilterOperator leftOperator = operator.getChildren().get(0);
        FilterOperator rightOperator = operator.getChildren().get(1);
        if (operator.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return QueryResultUtils.orQueryResultProcess(this.queryExpr(leftOperator, database, measurement, serviceProvider, fieldOrders, sessionId), this.queryExpr(rightOperator, database, measurement, serviceProvider, fieldOrders, sessionId));
        }
        if (operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            if (this.canMergeOperator(leftOperator) && this.canMergeOperator(rightOperator)) {
                List<IExpression> iExpressions1 = this.getIExpressionByFilterOperatorOperator(leftOperator);
                List<IExpression> iExpressions2 = this.getIExpressionByFilterOperatorOperator(rightOperator);
                iExpressions1.addAll(iExpressions2);
                return this.queryByConditions(iExpressions1, database, measurement, serviceProvider, fieldOrders, sessionId);
            }
            return QueryResultUtils.andQueryResultProcess(this.queryExpr(leftOperator, database, measurement, serviceProvider, fieldOrders, sessionId), this.queryExpr(rightOperator, database, measurement, serviceProvider, fieldOrders, sessionId));
        }
        throw new IllegalArgumentException("unknown operator " + operator);
    }

    private QueryResult queryByConditions(List<IExpression> expressions, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, Long sessionId) throws AuthException {
        HashMap<Integer, SingleSeriesExpression> realTagOrders = new HashMap<Integer, SingleSeriesExpression>();
        ArrayList<SingleSeriesExpression> fieldExpressions = new ArrayList<SingleSeriesExpression>();
        int currentQueryMaxTagNum = 0;
        Map<String, Integer> tagOrders = InfluxDBMetaManager.getTagOrders(database, measurement);
        for (IExpression expression : expressions) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)expression;
            if (tagOrders.containsKey(singleSeriesExpression.getSeriesPath().getFullPath())) {
                int curOrder = tagOrders.get(singleSeriesExpression.getSeriesPath().getFullPath());
                realTagOrders.put(curOrder, singleSeriesExpression);
                currentQueryMaxTagNum = Math.max(currentQueryMaxTagNum, curOrder);
                continue;
            }
            fieldExpressions.add(singleSeriesExpression);
        }
        StringBuilder curQueryPath = new StringBuilder("root." + database + "." + measurement);
        for (int i = 1; i <= currentQueryMaxTagNum; ++i) {
            if (realTagOrders.containsKey(i)) {
                curQueryPath.append(".").append(StringUtils.removeQuotation(FilterUtils.getFilterStringValue(((SingleSeriesExpression)realTagOrders.get(i)).getFilter())));
                continue;
            }
            curQueryPath.append(".").append("*");
        }
        if (currentQueryMaxTagNum < tagOrders.size()) {
            curQueryPath.append(".**");
        }
        StringBuilder realIotDBCondition = new StringBuilder();
        for (int i = 0; i < fieldExpressions.size(); ++i) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)fieldExpressions.get(i);
            if (i != 0) {
                realIotDBCondition.append(" and ");
            }
            realIotDBCondition.append(singleSeriesExpression.getSeriesPath().getFullPath()).append(" ").append(FilterUtils.getFilerSymbol(singleSeriesExpression.getFilter())).append(" ").append(FilterUtils.getFilterStringValue(singleSeriesExpression.getFilter()));
        }
        String realQuerySql = "select * from " + curQueryPath;
        if (realIotDBCondition.length() != 0) {
            realQuerySql = realQuerySql + " where " + realIotDBCondition;
        }
        realQuerySql = realQuerySql + " align by device";
        return this.queryByConditions(realQuerySql, database, measurement, serviceProvider, fieldOrders, (long)sessionId);
    }

    public List<IExpression> getIExpressionByFilterOperatorOperator(FilterOperator filterOperator) {
        if (filterOperator instanceof BasicFunctionOperator) {
            ArrayList<IExpression> expressions = new ArrayList<IExpression>();
            expressions.add(this.getIExpressionForBasicFunctionOperator((BasicFunctionOperator)filterOperator));
            return expressions;
        }
        FilterOperator leftOperator = filterOperator.getChildren().get(0);
        FilterOperator rightOperator = filterOperator.getChildren().get(1);
        List<IExpression> expressions1 = this.getIExpressionByFilterOperatorOperator(leftOperator);
        List<IExpression> expressions2 = this.getIExpressionByFilterOperatorOperator(rightOperator);
        expressions1.addAll(expressions2);
        return expressions1;
    }

    public boolean canMergeOperator(FilterOperator operator) {
        if (operator instanceof BasicFunctionOperator) {
            return true;
        }
        if (operator.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return false;
        }
        FilterOperator leftOperator = operator.getChildren().get(0);
        FilterOperator rightOperator = operator.getChildren().get(1);
        return this.canMergeOperator(leftOperator) && this.canMergeOperator(rightOperator);
    }

    public void checkInfluxDBQueryOperator(Operator operator) {
        if (!(operator instanceof InfluxQueryOperator)) {
            throw new IllegalArgumentException("not query sql");
        }
        InfluxSelectComponent selectComponent = ((InfluxQueryOperator)operator).getSelectComponent();
        if (selectComponent.isHasMoreSelectorFunction() && selectComponent.isHasCommonQuery()) {
            throw new IllegalArgumentException("ERR: mixing multiple selector functions with tags or fields is not supported");
        }
        if (selectComponent.isHasAggregationFunction() && selectComponent.isHasCommonQuery()) {
            throw new IllegalArgumentException("ERR: mixing aggregate and non-aggregate queries is not supported");
        }
    }
}

