/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class GetRegionStatement
extends Statement
implements IConfigStatement {
    private final String storageGroup;
    private final TSeriesPartitionSlot seriesSlotId;
    private final TConsensusGroupType partitionType;
    private TTimePartitionSlot timeSlotId;

    public GetRegionStatement(String storageGroup, TConsensusGroupType partitionType, TSeriesPartitionSlot seriesSlotId) {
        this.storageGroup = storageGroup;
        this.partitionType = partitionType;
        this.seriesSlotId = seriesSlotId;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    public TSeriesPartitionSlot getSeriesSlotId() {
        return this.seriesSlotId;
    }

    public TTimePartitionSlot getTimeSlotId() {
        return this.timeSlotId;
    }

    public void setTimeSlotId(TTimePartitionSlot timeSlotId) {
        this.timeSlotId = timeSlotId;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitGetRegion(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    public List<PartialPath> getPaths() {
        try {
            return Collections.singletonList(new PartialPath(this.storageGroup));
        }
        catch (IllegalPathException e) {
            return new ArrayList<PartialPath>();
        }
    }
}

