/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.rewriter;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.filter.FunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.db.mpp.plan.rewriter.IFilterOptimizer;

public class RemoveNotOptimizer
implements IFilterOptimizer {
    @Override
    public QueryFilter optimize(QueryFilter filter) throws StatementAnalyzeException {
        Set<PartialPath> pathSet = filter.getPathSet();
        QueryFilter optimizedFilter = this.removeNot(filter);
        optimizedFilter.setPathSet(pathSet);
        return optimizedFilter;
    }

    private QueryFilter removeNot(QueryFilter filter) throws StatementAnalyzeException {
        if (filter.isLeaf()) {
            return filter;
        }
        FilterConstant.FilterType filterType = filter.getFilterType();
        switch (filterType) {
            case KW_AND: 
            case KW_OR: {
                List<QueryFilter> children = filter.getChildren();
                if (children.size() < 2) {
                    throw new StatementAnalyzeException("Filter has some time series don't correspond to any known time series");
                }
                children.set(0, this.removeNot(children.get(0)));
                children.set(1, this.removeNot(children.get(1)));
                return filter;
            }
            case KW_NOT: {
                if (filter.getChildren().size() < 1) {
                    throw new StatementAnalyzeException("Filter has some time series don't correspond to any known time series");
                }
                return this.reverseFilter(filter.getChildren().get(0));
            }
        }
        throw new StatementAnalyzeException("removeNot", filterType);
    }

    private QueryFilter reverseFilter(QueryFilter filter) throws StatementAnalyzeException {
        FilterConstant.FilterType filterType = filter.getFilterType();
        if (filter.isLeaf()) {
            ((FunctionFilter)filter).reverseFunc();
            return filter;
        }
        switch (filterType) {
            case KW_AND: 
            case KW_OR: {
                List<QueryFilter> children = filter.getChildren();
                children.set(0, this.reverseFilter(children.get(0)));
                children.set(1, this.reverseFilter(children.get(1)));
                filter.setFilterType(FilterConstant.filterReverseWords.get((Object)filterType));
                return filter;
            }
            case KW_NOT: {
                return this.removeNot(filter.getChildren().get(0));
            }
        }
        throw new StatementAnalyzeException("reverseFilter", filterType);
    }
}

