/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.AbstractSchemaMergeNode;

public class SchemaQueryMergeNode
extends AbstractSchemaMergeNode {
    private boolean orderByHeat;

    public SchemaQueryMergeNode(PlanNodeId id) {
        super(id);
    }

    public SchemaQueryMergeNode(PlanNodeId id, boolean orderByHeat) {
        this(id);
        this.orderByHeat = orderByHeat;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    @Override
    public PlanNode clone() {
        return new SchemaQueryMergeNode(this.getPlanNodeId(), this.orderByHeat);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SCHEMA_QUERY_MERGE.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SCHEMA_QUERY_MERGE.serialize(stream);
    }

    public static SchemaQueryMergeNode deserialize(ByteBuffer byteBuffer) {
        PlanNodeId id = PlanNodeId.deserialize(byteBuffer);
        return new SchemaQueryMergeNode(id);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSchemaQueryMerge(this, context);
    }

    public String toString() {
        return String.format("SchemaMergeNode-%s", this.getPlanNodeId());
    }
}

