/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.LevelTimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class CountMergeOperator
implements ProcessOperator {
    private final PlanNodeId planNodeId;
    private final OperatorContext operatorContext;
    private List<TsBlock> tsBlockList = new ArrayList<TsBlock>();
    private int currentIndex = 0;
    private final List<Operator> children;
    private final boolean isGroupByLevel;

    public CountMergeOperator(PlanNodeId planNodeId, OperatorContext operatorContext, List<Operator> children) {
        this.planNodeId = planNodeId;
        this.operatorContext = operatorContext;
        this.children = children;
        this.isGroupByLevel = children.get(0) instanceof LevelTimeSeriesCountOperator;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        for (Operator child : this.children) {
            while (!child.isFinished()) {
                TsBlock tsBlock;
                ListenableFuture<?> blocked = child.isBlocked();
                if (!blocked.isDone()) {
                    return blocked;
                }
                if (!child.hasNext() || null == (tsBlock = child.next()) || tsBlock.isEmpty()) continue;
                this.tsBlockList.add(tsBlock);
            }
        }
        this.generateResultTsBlockList();
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        return this.tsBlockList.get(this.currentIndex - 1);
    }

    private void generateResultTsBlockList() {
        if (this.isGroupByLevel) {
            this.generateResultWithGroupByLevel();
        } else {
            this.generateResultWithoutGroupByLevel();
        }
    }

    private void generateResultWithoutGroupByLevel() {
        int totalCount = 0;
        for (TsBlock tsBlock : this.tsBlockList) {
            int count = tsBlock.getColumn(0).getInt(0);
            totalCount += count;
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeInt(totalCount);
        tsBlockBuilder.declarePosition();
        this.tsBlockList = Collections.singletonList(tsBlockBuilder.build());
    }

    private void generateResultWithGroupByLevel() {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (TsBlock tsBlock : this.tsBlockList) {
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String columnName = tsBlock.getColumn(0).getBinary(i).getStringValue();
                int count = tsBlock.getColumn(1).getInt(i);
                countMap.put(columnName, countMap.getOrDefault(columnName, 0) + count);
            }
        }
        this.tsBlockList = SchemaTsBlockUtil.transferSchemaResultToTsBlockList(countMap.entrySet().iterator(), Arrays.asList(TSDataType.TEXT, TSDataType.INT32), (entry, tsBlockBuilder) -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary((String)entry.getKey()));
            tsBlockBuilder.getColumnBuilder(1).writeInt(((Integer)entry.getValue()).intValue());
            tsBlockBuilder.declarePosition();
        });
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.tsBlockList.size();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }
}

