/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.execution.StateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceFailureListener;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FragmentInstanceStateMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceStateMachine.class);
    private final long createdTime = System.currentTimeMillis();
    private final FragmentInstanceId instanceId;
    private final Executor executor;
    private final StateMachine<FragmentInstanceState> instanceState;
    private final LinkedBlockingQueue<Throwable> failureCauses = new LinkedBlockingQueue();
    @GuardedBy(value="this")
    private final Map<FragmentInstanceId, Throwable> sourceInstanceFailures = new HashMap<FragmentInstanceId, Throwable>();
    @GuardedBy(value="this")
    private final List<FragmentInstanceFailureListener> sourceInstanceFailureListeners = new ArrayList<FragmentInstanceFailureListener>();

    public FragmentInstanceStateMachine(FragmentInstanceId fragmentInstanceId, Executor executor) {
        this.instanceId = Objects.requireNonNull(fragmentInstanceId, "fragmentInstanceId is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.instanceState = new StateMachine<FragmentInstanceState>("FragmentInstance " + fragmentInstanceId, executor, FragmentInstanceState.RUNNING, FragmentInstanceState.TERMINAL_INSTANCE_STATES);
        this.instanceState.addStateChangeListener((T newState) -> {
            try (SetThreadName threadName = new SetThreadName(fragmentInstanceId.getFullId());){
                LOGGER.info("[StateChanged] To {}", (Object)newState);
            }
        });
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public FragmentInstanceId getFragmentInstanceId() {
        return this.instanceId;
    }

    public FragmentInstanceState getState() {
        return this.instanceState.get();
    }

    public ListenableFuture<FragmentInstanceState> getStateChange(FragmentInstanceState currentState) {
        Objects.requireNonNull(currentState, "currentState is null");
        Preconditions.checkArgument((!currentState.isDone() ? 1 : 0) != 0, (Object)"Current state is already done");
        ListenableFuture<FragmentInstanceState> future = this.instanceState.getStateChange(currentState);
        FragmentInstanceState state = this.instanceState.get();
        if (state.isDone()) {
            return Futures.immediateFuture((Object)((Object)state));
        }
        return future;
    }

    public LinkedBlockingQueue<Throwable> getFailureCauses() {
        return this.failureCauses;
    }

    public void transitionToFlushing() {
        this.instanceState.setIf(FragmentInstanceState.FLUSHING, currentState -> currentState == FragmentInstanceState.RUNNING);
    }

    public void finished() {
        this.transitionToDoneState(FragmentInstanceState.FINISHED);
    }

    public void cancel() {
        this.transitionToDoneState(FragmentInstanceState.CANCELLED);
    }

    public void abort() {
        this.transitionToDoneState(FragmentInstanceState.ABORTED);
    }

    public void failed(Throwable cause) {
        this.failureCauses.add(cause);
        this.transitionToDoneState(FragmentInstanceState.FAILED);
    }

    private void transitionToDoneState(FragmentInstanceState doneState) {
        Objects.requireNonNull(doneState, "doneState is null");
        Preconditions.checkArgument((boolean)doneState.isDone(), (String)"doneState %s is not a done state", (Object)((Object)doneState));
        this.instanceState.setIf(doneState, currentState -> !currentState.isDone());
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<FragmentInstanceState> stateChangeListener) {
        this.instanceState.addStateChangeListener(stateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceTaskFailureListener(FragmentInstanceFailureListener listener) {
        ImmutableMap failures;
        FragmentInstanceStateMachine fragmentInstanceStateMachine = this;
        synchronized (fragmentInstanceStateMachine) {
            this.sourceInstanceFailureListeners.add(listener);
            failures = ImmutableMap.copyOf(this.sourceInstanceFailures);
        }
        this.executor.execute(() -> FragmentInstanceStateMachine.lambda$addSourceTaskFailureListener$3((Map)failures, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sourceTaskFailed(FragmentInstanceId instanceId, Throwable failure) {
        ImmutableList listeners;
        FragmentInstanceStateMachine fragmentInstanceStateMachine = this;
        synchronized (fragmentInstanceStateMachine) {
            this.sourceInstanceFailures.putIfAbsent(instanceId, failure);
            listeners = ImmutableList.copyOf(this.sourceInstanceFailureListeners);
        }
        this.executor.execute(() -> FragmentInstanceStateMachine.lambda$sourceTaskFailed$4((List)listeners, instanceId, failure));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("FragmentInstanceId", (Object)this.instanceId).add("FragmentInstanceState", this.instanceState).add("failureCauses", this.failureCauses).toString();
    }

    private static /* synthetic */ void lambda$sourceTaskFailed$4(List listeners, FragmentInstanceId instanceId, Throwable failure) {
        for (FragmentInstanceFailureListener listener : listeners) {
            listener.onTaskFailed(instanceId, failure);
        }
    }

    private static /* synthetic */ void lambda$addSourceTaskFailureListener$3(Map failures, FragmentInstanceFailureListener listener) {
        failures.forEach(listener::onTaskFailed);
    }
}

