/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.utils.ResourceByPathUtils;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

class MeasurementResourceByPathUtils
extends ResourceByPathUtils {
    MeasurementPath partialPath;

    protected MeasurementResourceByPathUtils(PartialPath partialPath) {
        this.partialPath = (MeasurementPath)partialPath;
    }

    @Override
    public LastPointReader createLastPointReader(TSDataType dataType, Set<String> deviceMeasurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        return new LastPointReader((PartialPath)this.partialPath, dataType, deviceMeasurements, context, dataSource, queryTime, timeFilter);
    }

    @Override
    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        return new SeriesReader((PartialPath)this.partialPath, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    @Override
    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        allSensors.add(this.partialPath.getMeasurement());
        return new SeriesReader((PartialPath)this.partialPath, allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, valueFilter, ascending);
    }

    @Override
    public TsFileResource createTsFileResource(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        TsFileResource tsFileResource = new TsFileResource((PartialPath)this.partialPath, readOnlyMemChunk, chunkMetadataList, originTsFileResource);
        tsFileResource.setTimeSeriesMetadata((PartialPath)this.partialPath, this.generateTimeSeriesMetadata(readOnlyMemChunk, chunkMetadataList));
        return tsFileResource;
    }

    @Override
    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) throws IOException {
        TimeseriesMetadata timeSeriesMetadata = new TimeseriesMetadata();
        timeSeriesMetadata.setMeasurementId(this.partialPath.getMeasurementSchema().getMeasurementId());
        timeSeriesMetadata.setTSDataType(this.partialPath.getMeasurementSchema().getType());
        timeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
        timeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        Statistics seriesStatistics = Statistics.getStatsByType((TSDataType)timeSeriesMetadata.getTSDataType());
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            seriesStatistics.mergeStatistics(memChunk.getChunkMetaData().getStatistics());
        }
        timeSeriesMetadata.setStatistics(seriesStatistics);
        return timeSeriesMetadata;
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID(this.partialPath.getDevicePath())) || !memTableMap.get(deviceID).contains(this.partialPath.getMeasurement())) {
            return null;
        }
        IWritableMemChunk memChunk = memTableMap.get(deviceID).getMemChunkMap().get(this.partialPath.getMeasurement());
        TVList chunkCopy = memChunk.getSortedTvListForQuery();
        List<TimeRange> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = this.constructDeletionList(memTable, modsToMemtable, timeLowerBound);
        }
        return new ReadOnlyMemChunk(this.partialPath.getMeasurement(), this.partialPath.getMeasurementSchema().getType(), this.partialPath.getMeasurementSchema().getEncodingType(), chunkCopy, this.partialPath.getMeasurementSchema().getProps(), deletionList);
    }

    private List<TimeRange> constructDeletionList(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : this.getModificationsForMemtable(memTable, modsToMemtable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath((PartialPath)this.partialPath) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    @Override
    protected List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        ModificationFile modificationFile = tsFileResource.getModFile();
        List<Modification> modifications = context.getPathModifications(modificationFile, (PartialPath)this.partialPath);
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>(writer.getVisibleMetadataList(this.partialPath.getDevice(), this.partialPath.getMeasurement(), this.partialPath.getSeriesType()));
        QueryUtils.modifyChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(context::chunkNotSatisfy);
        return chunkMetadataList;
    }
}

