/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;

public class SchemaRegionUtils {
    public static void deleteSchemaRegionFolder(String schemaRegionDirPath, Logger logger) throws MetadataException {
        File schemaRegionDir = SystemFileFactory.INSTANCE.getFile(schemaRegionDirPath);
        File[] sgFiles = schemaRegionDir.listFiles();
        if (sgFiles == null) {
            throw new MetadataException(String.format("Can't get files in schema region dir %s", schemaRegionDirPath));
        }
        for (File file : sgFiles) {
            if (!file.delete()) {
                logger.info("delete schema region file {} failed.", (Object)file.getAbsolutePath());
                throw new MetadataException(String.format("Failed to delete schema region file %s", file.getAbsolutePath()));
            }
            logger.info("delete schema region file {}", (Object)file.getAbsolutePath());
        }
        if (!schemaRegionDir.delete()) {
            logger.info("delete schema region folder {} failed.", (Object)schemaRegionDir.getAbsolutePath());
            throw new MetadataException(String.format("Failed to delete schema region folder %s", schemaRegionDir.getAbsolutePath()));
        }
        logger.info("delete schema region folder {}", (Object)schemaRegionDir.getAbsolutePath());
        File storageGroupDir = schemaRegionDir.getParentFile();
        if (Objects.requireNonNull(storageGroupDir.listFiles()).length == 0) {
            storageGroupDir.delete();
        }
    }

    public static void checkDataTypeMatch(InsertPlan plan, int loc, TSDataType dataTypeInSchema) throws MetadataException {
        TSDataType insertDataType = plan instanceof InsertRowPlan ? (!((InsertRowPlan)plan).isNeedInferType() ? SchemaRegionUtils.getTypeInLoc(plan, loc) : dataTypeInSchema) : SchemaRegionUtils.getTypeInLoc(plan, loc);
        if (dataTypeInSchema != insertDataType) {
            String measurement = plan.getMeasurements()[loc];
            String device = plan.getDevicePath().getFullPath();
            throw new DataTypeMismatchException(device, measurement, insertDataType, dataTypeInSchema, plan.getMinTime(), plan.getFirstValueOfIndex(loc));
        }
    }

    private static TSDataType getTypeInLoc(InsertPlan plan, int loc) throws MetadataException {
        TSDataType dataType;
        if (plan instanceof InsertRowPlan) {
            InsertRowPlan tPlan = (InsertRowPlan)plan;
            dataType = TypeInferenceUtils.getPredictedDataType(tPlan.getValues()[loc], tPlan.isNeedInferType());
        } else if (plan instanceof InsertTabletPlan) {
            dataType = plan.getDataTypes()[loc];
        } else {
            throw new MetadataException(String.format("Only support insert and insertTablet, plan is [%s]", new Object[]{plan.getOperatorType()}));
        }
        return dataType;
    }
}

