/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStatistics {
    private static final Logger logger = LoggerFactory.getLogger(MemoryStatistics.class);
    private long memoryCapacity;
    private final AtomicLong memoryUsage = new AtomicLong(0L);
    private volatile boolean allowToCreateNewSeries;

    public static MemoryStatistics getInstance() {
        return MemoryStatisticsHolder.INSTANCE;
    }

    private MemoryStatistics() {
    }

    public void init() {
        this.memoryCapacity = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion();
        this.memoryUsage.getAndSet(0L);
        this.allowToCreateNewSeries = true;
    }

    public boolean isAllowToCreateNewSeries() {
        return this.allowToCreateNewSeries;
    }

    public boolean isExceedCapacity() {
        return this.memoryUsage.get() > this.memoryCapacity;
    }

    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    public long getMemoryUsage() {
        return this.memoryUsage.get();
    }

    public void requestMemory(long size) {
        this.memoryUsage.getAndUpdate(v -> v += size);
        if (this.memoryUsage.get() >= this.memoryCapacity) {
            logger.warn("Current series number {} is too large...", (Object)this.memoryUsage);
            this.allowToCreateNewSeries = false;
        }
    }

    public void releaseMemory(long size) {
        this.memoryUsage.getAndUpdate(v -> v -= size);
        if (!this.allowToCreateNewSeries && this.memoryUsage.get() < this.memoryCapacity) {
            logger.info("Current series number {} come back to normal level", (Object)this.memoryUsage);
            this.allowToCreateNewSeries = true;
        }
    }

    public void clear() {
        this.memoryUsage.getAndSet(0L);
        this.allowToCreateNewSeries = true;
    }

    private static class MemoryStatisticsHolder {
        private static final MemoryStatistics INSTANCE = new MemoryStatistics();

        private MemoryStatisticsHolder() {
        }
    }
}

