/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.plan.schemaregion;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum SchemaRegionPlanType {
    CREATE_TIMESERIES(4),
    DELETE_TIMESERIES(21),
    CHANGE_TAG_OFFSET(28),
    CHANGE_ALIAS(29),
    SET_TEMPLATE(38),
    ACTIVATE_TEMPLATE(39),
    AUTO_CREATE_DEVICE_MNODE(40),
    CREATE_ALIGNED_TIMESERIES(41),
    UNSET_TEMPLATE(57),
    ACTIVATE_TEMPLATE_IN_CLUSTER(63),
    PRE_DELETE_TIMESERIES_IN_CLUSTER(64),
    ROLLBACK_PRE_DELETE_TIMESERIES(65);

    public static final int MAX_NUM = 127;
    private static final SchemaRegionPlanType[] PLAN_TYPE_TABLE;
    private final byte planType;

    private SchemaRegionPlanType(byte planType) {
        this.planType = planType;
    }

    public byte getPlanType() {
        return this.planType;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.planType);
    }

    public static SchemaRegionPlanType deserialize(ByteBuffer buffer) {
        byte code = buffer.get();
        SchemaRegionPlanType type = PLAN_TYPE_TABLE[code];
        if (type == null) {
            throw new IllegalArgumentException("Unrecognized SchemaRegionPlanType of " + code);
        }
        return type;
    }

    static {
        PLAN_TYPE_TABLE = new SchemaRegionPlanType[127];
        SchemaRegionPlanType[] schemaRegionPlanTypeArray = SchemaRegionPlanType.values();
        int n = schemaRegionPlanTypeArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaRegionPlanType type;
            SchemaRegionPlanType.PLAN_TYPE_TABLE[type.planType] = type = schemaRegionPlanTypeArray[i];
        }
    }
}

