/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.lastCache.container.LastCacheContainer;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;

public class EntityMNode
extends InternalMNode
implements IEntityMNode {
    private volatile transient Map<String, IMeasurementMNode> aliasChildren = null;
    private volatile boolean isAligned = false;
    private volatile Map<String, ILastCacheContainer> lastCacheMap = null;

    @Override
    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath().intern();
        }
        return this.fullPath;
    }

    public EntityMNode(IMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name) || this.aliasChildren != null && this.aliasChildren.containsKey(name);
    }

    @Override
    public IMNode getChild(String name) {
        IMNode child = null;
        if (this.children != null) {
            child = (IMNode)this.children.get(name);
        }
        if (child != null) {
            return child;
        }
        return this.aliasChildren == null ? null : (IMNode)this.aliasChildren.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAlias(String alias, IMeasurementMNode child) {
        if (this.aliasChildren == null) {
            EntityMNode entityMNode = this;
            synchronized (entityMNode) {
                if (this.aliasChildren == null) {
                    this.aliasChildren = new ConcurrentHashMap<String, IMeasurementMNode>();
                }
            }
        }
        return this.aliasChildren.computeIfAbsent(alias, aliasName -> child) == child;
    }

    @Override
    public void deleteAliasChild(String alias) {
        if (this.aliasChildren != null) {
            this.aliasChildren.remove(alias);
        }
    }

    @Override
    public Map<String, IMeasurementMNode> getAliasChildren() {
        if (this.aliasChildren == null) {
            return Collections.emptyMap();
        }
        return this.aliasChildren;
    }

    @Override
    public void setAliasChildren(Map<String, IMeasurementMNode> aliasChildren) {
        this.aliasChildren = aliasChildren;
    }

    @Override
    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public void setAligned(boolean isAligned) {
        this.isAligned = isAligned;
    }

    @Override
    public ILastCacheContainer getLastCacheContainer(String measurementId) {
        this.checkLastCacheMap();
        return this.lastCacheMap.computeIfAbsent(measurementId, k -> new LastCacheContainer());
    }

    @Override
    public Map<String, ILastCacheContainer> getTemplateLastCaches() {
        return this.lastCacheMap == null ? Collections.emptyMap() : this.lastCacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLastCacheMap() {
        if (this.lastCacheMap == null) {
            EntityMNode entityMNode = this;
            synchronized (entityMNode) {
                if (this.lastCacheMap == null) {
                    this.lastCacheMap = new ConcurrentHashMap<String, ILastCacheContainer>();
                }
            }
        }
    }

    @Override
    public void moveDataToNewMNode(IMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        if (newMNode.isEntity()) {
            IEntityMNode newEntityMNode = newMNode.getAsEntityMNode();
            newEntityMNode.setAligned(this.isAligned);
            if (this.aliasChildren != null) {
                newEntityMNode.setAliasChildren(this.aliasChildren);
            }
        }
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public MNodeType getMNodeType(Boolean isConfig) {
        return MNodeType.DEVICE;
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitEntityMNode(this, context);
    }
}

