/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.timeindex.FileTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class V012FileTimeIndex
implements ITimeIndex {
    FileTimeIndex fileTimeIndex;

    public FileTimeIndex getFileTimeIndex() {
        return this.fileTimeIndex;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and serialize() method should not be called any more.");
    }

    @Override
    public ITimeIndex deserialize(InputStream inputStream) throws IOException {
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            ReadWriteIOUtils.readString((InputStream)inputStream);
        }
        this.fileTimeIndex = new FileTimeIndex(ReadWriteIOUtils.readLong((InputStream)inputStream), ReadWriteIOUtils.readLong((InputStream)inputStream));
        return this;
    }

    @Override
    public ITimeIndex deserialize(ByteBuffer buffer) {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            SerializeUtils.deserializeString((ByteBuffer)buffer);
        }
        this.fileTimeIndex = new FileTimeIndex(buffer.getLong(), buffer.getLong());
        return this;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and close() method should not be called any more.");
    }

    @Override
    public Set<String> getDevices(String tsFilePath, TsFileResource tsFileResource) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getDevices() method should not be called any more.");
    }

    @Override
    public boolean endTimeEmpty() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and endTimeEmpty() method should not be called any more.");
    }

    @Override
    public boolean stillLives(long timeLowerBound) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and stillLives() method should not be called any more.");
    }

    @Override
    public long calculateRamSize() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and calculateRamSize() method should not be called any more.");
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getTimePartition() method should not be called any more.");
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getTimePartitionWithCheck() method should not be called any more.");
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and isSpanMultiTimePartitions() method should not be called any more.");
    }

    @Override
    public void updateStartTime(String deviceId, long time) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and updateStartTime() method should not be called any more.");
    }

    @Override
    public void updateEndTime(String deviceId, long time) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and updateEndTime() method should not be called any more.");
    }

    @Override
    public void putStartTime(String deviceId, long time) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and putStartTime() method should not be called any more.");
    }

    @Override
    public void putEndTime(String deviceId, long time) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and putEndTime() method should not be called any more.");
    }

    @Override
    public long getStartTime(String deviceId) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getStartTime() method should not be called any more.");
    }

    @Override
    public long getEndTime(String deviceId) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getEndTime() method should not be called any more.");
    }

    @Override
    public boolean checkDeviceIdExist(String deviceId) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and checkDeviceIdExist() method should not be called any more.");
    }

    @Override
    public long getMinStartTime() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getMinStartTime() method should not be called any more.");
    }

    @Override
    public long getMaxEndTime() {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getMaxEndTime() method should not be called any more.");
    }

    @Override
    public int compareDegradePriority(ITimeIndex timeIndex) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and compareDegradePriority() method should not be called any more.");
    }

    @Override
    public boolean mayContainsDevice(String device) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and containsDevice() method should not be called any more.");
    }

    @Override
    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern) {
        throw new UnsupportedOperationException("V012FileTimeIndex should be rewritten while upgrading and getPossibleStartTimeAndEndTime() method should not be called any more.");
    }

    @Override
    public byte getTimeIndexType() {
        return 0;
    }
}

