/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsRecorder;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger((String)"COMPACTION");
    private final int threadId;
    private final FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue;

    public CompactionWorker(int threadId, FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue) {
        this.threadId = threadId;
        this.compactionTaskQueue = compactionTaskQueue;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                AbstractCompactionTask task = null;
                try {
                    task = this.compactionTaskQueue.take();
                }
                catch (InterruptedException e) {
                    log.warn("CompactionThread-{} terminates because interruption", (Object)this.threadId);
                    return;
                }
                if (task == null) continue;
                CompactionMetricsRecorder.recordTaskInfo(task, CompactionTaskStatus.POLL_FROM_QUEUE, this.compactionTaskQueue.size());
                if (!task.checkValidAndSetMerging()) continue;
                CompactionTaskSummary summary = task.getSummary();
                CompactionTaskFuture future = new CompactionTaskFuture(summary);
                CompactionTaskManager.getInstance().recordTask(task, future);
                task.start();
            }
            catch (Throwable t) {
                log.error("CompactionWorker.run(), Exception.", t);
            }
        }
    }

    static class CompactionTaskFuture
    implements Future<CompactionTaskSummary> {
        CompactionTaskSummary summary;

        public CompactionTaskFuture(CompactionTaskSummary summary) {
            this.summary = summary;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.summary.cancel();
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.summary.isCancel();
        }

        @Override
        public boolean isDone() {
            return this.summary.isFinished();
        }

        @Override
        public CompactionTaskSummary get() throws InterruptedException, ExecutionException {
            while (!this.summary.isFinished()) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            return this.summary;
        }

        @Override
        public CompactionTaskSummary get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long perSleepTime = timeout < 100L ? timeout : 100L;
            long totalSleepTime = 0L;
            while (!this.summary.isFinished()) {
                if (totalSleepTime >= timeout) {
                    throw new TimeoutException("Timeout when trying to get compaction task summary");
                }
                unit.sleep(perSleepTime);
                totalSleepTime += perSleepTime;
            }
            return this.summary;
        }
    }
}

