/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeseriesMetadata
implements ITimeSeriesMetadata {
    private long startOffsetOfChunkMetaDataList;
    private byte timeSeriesMetadataType;
    private int chunkMetaDataListDataSize;
    private String measurementId;
    private TSDataType dataType;
    private Statistics<? extends Serializable> statistics;
    private boolean modified;
    private IChunkMetadataLoader chunkMetadataLoader;
    private long ramSize;
    private boolean isSeq = true;
    private PublicBAOS chunkMetadataListBuffer;
    private ArrayList<IChunkMetadata> chunkMetadataList;

    public TimeseriesMetadata() {
    }

    public TimeseriesMetadata(byte timeSeriesMetadataType, int chunkMetaDataListDataSize, String measurementId, TSDataType dataType, Statistics<? extends Serializable> statistics, PublicBAOS chunkMetadataListBuffer) {
        this.timeSeriesMetadataType = timeSeriesMetadataType;
        this.chunkMetaDataListDataSize = chunkMetaDataListDataSize;
        this.measurementId = measurementId;
        this.dataType = dataType;
        this.statistics = statistics;
        this.chunkMetadataListBuffer = chunkMetadataListBuffer;
    }

    public TimeseriesMetadata(TimeseriesMetadata timeseriesMetadata) {
        this.timeSeriesMetadataType = timeseriesMetadata.timeSeriesMetadataType;
        this.chunkMetaDataListDataSize = timeseriesMetadata.chunkMetaDataListDataSize;
        this.measurementId = timeseriesMetadata.measurementId;
        this.dataType = timeseriesMetadata.dataType;
        this.statistics = timeseriesMetadata.statistics;
        this.modified = timeseriesMetadata.modified;
        this.chunkMetadataList = new ArrayList<IChunkMetadata>(timeseriesMetadata.chunkMetadataList);
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, boolean needChunkMetadata) {
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setTimeSeriesMetadataType(ReadWriteIOUtils.readByte(buffer));
        timeseriesMetaData.setMeasurementId(ReadWriteIOUtils.readVarIntString(buffer));
        timeseriesMetaData.setTSDataType(ReadWriteIOUtils.readDataType(buffer));
        int chunkMetaDataListDataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(chunkMetaDataListDataSize);
        timeseriesMetaData.setStatistics(Statistics.deserialize(buffer, timeseriesMetaData.dataType));
        if (needChunkMetadata) {
            ByteBuffer byteBuffer = buffer.slice();
            byteBuffer.limit(chunkMetaDataListDataSize);
            timeseriesMetaData.chunkMetadataList = new ArrayList();
            while (byteBuffer.hasRemaining()) {
                timeseriesMetaData.chunkMetadataList.add(ChunkMetadata.deserializeFrom(byteBuffer, timeseriesMetaData));
            }
            timeseriesMetaData.chunkMetadataList.trimToSize();
        }
        buffer.position(buffer.position() + chunkMetaDataListDataSize);
        return timeseriesMetaData;
    }

    public static TimeseriesMetadata deserializeFrom(ByteBuffer buffer, Set<String> excludedMeasurements, boolean needChunkMetadata) {
        byte timeseriesType = ReadWriteIOUtils.readByte(buffer);
        String measurementID = ReadWriteIOUtils.readVarIntString(buffer);
        TSDataType tsDataType = ReadWriteIOUtils.readDataType(buffer);
        int chunkMetaDataListDataSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        Statistics<Serializable> statistics = Statistics.deserialize(buffer, tsDataType);
        if (excludedMeasurements.contains(measurementID)) {
            buffer.position(buffer.position() + chunkMetaDataListDataSize);
            return null;
        }
        TimeseriesMetadata timeseriesMetaData = new TimeseriesMetadata();
        timeseriesMetaData.setTimeSeriesMetadataType(timeseriesType);
        timeseriesMetaData.setMeasurementId(measurementID);
        timeseriesMetaData.setTSDataType(tsDataType);
        timeseriesMetaData.setDataSizeOfChunkMetaDataList(chunkMetaDataListDataSize);
        timeseriesMetaData.setStatistics(statistics);
        if (needChunkMetadata) {
            ByteBuffer byteBuffer = buffer.slice();
            byteBuffer.limit(chunkMetaDataListDataSize);
            timeseriesMetaData.chunkMetadataList = new ArrayList();
            while (byteBuffer.hasRemaining()) {
                timeseriesMetaData.chunkMetadataList.add(ChunkMetadata.deserializeFrom(byteBuffer, timeseriesMetaData));
            }
            timeseriesMetaData.chunkMetadataList.trimToSize();
        }
        buffer.position(buffer.position() + chunkMetaDataListDataSize);
        return timeseriesMetaData;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.timeSeriesMetadataType, outputStream);
        byteLen += ReadWriteIOUtils.writeVar(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.dataType, outputStream);
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.chunkMetaDataListDataSize, outputStream);
        byteLen += this.statistics.serialize(outputStream);
        this.chunkMetadataListBuffer.writeTo(outputStream);
        return byteLen += this.chunkMetadataListBuffer.size();
    }

    public byte getTimeSeriesMetadataType() {
        return this.timeSeriesMetadataType;
    }

    public void setTimeSeriesMetadataType(byte timeSeriesMetadataType) {
        this.timeSeriesMetadataType = timeSeriesMetadataType;
    }

    public long getOffsetOfChunkMetaDataList() {
        return this.startOffsetOfChunkMetaDataList;
    }

    public void setOffsetOfChunkMetaDataList(long position) {
        this.startOffsetOfChunkMetaDataList = position;
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public void setMeasurementId(String measurementId) {
        this.measurementId = measurementId;
    }

    public int getDataSizeOfChunkMetaDataList() {
        return this.chunkMetaDataListDataSize;
    }

    public void setDataSizeOfChunkMetaDataList(int size) {
        this.chunkMetaDataListDataSize = size;
    }

    public TSDataType getTSDataType() {
        return this.dataType;
    }

    public void setTSDataType(TSDataType tsDataType) {
        this.dataType = tsDataType;
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics<? extends Serializable> statistics) {
        this.statistics = statistics;
    }

    @Override
    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    public IChunkMetadataLoader getChunkMetadataLoader() {
        return this.chunkMetadataLoader;
    }

    @Override
    public List<IChunkMetadata> loadChunkMetadataList() throws IOException {
        return this.chunkMetadataLoader.loadChunkMetadataList(this);
    }

    public List<IChunkMetadata> getChunkMetadataList() {
        return this.chunkMetadataList;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    @Override
    public boolean isSeq() {
        return this.isSeq;
    }

    public void setChunkMetadataListBuffer(PublicBAOS chunkMetadataListBuffer) {
        this.chunkMetadataListBuffer = chunkMetadataListBuffer;
    }

    public void setChunkMetadataList(ArrayList<ChunkMetadata> chunkMetadataList) {
        this.chunkMetadataList = new ArrayList<ChunkMetadata>(chunkMetadataList);
    }

    public String toString() {
        return "TimeseriesMetadata{startOffsetOfChunkMetaDataList=" + this.startOffsetOfChunkMetaDataList + ", timeSeriesMetadataType=" + this.timeSeriesMetadataType + ", chunkMetaDataListDataSize=" + this.chunkMetaDataListDataSize + ", measurementId='" + this.measurementId + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", statistics=" + this.statistics + ", modified=" + this.modified + ", isSeq=" + this.isSeq + ", chunkMetadataList=" + this.chunkMetadataList + '}';
    }
}

