/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.utils.Pair;

public class WildcardsRemover {
    private int soffset = 0;
    private int currentOffset = 0;
    private int currentLimit = IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum() + 1;
    private int consumed = 0;
    private boolean isPrefixMatch;

    public WildcardsRemover(QueryOperator queryOperator) {
        this.isPrefixMatch = queryOperator.isPrefixMatchPath();
        if (queryOperator.getSpecialClauseComponent() != null) {
            this.currentOffset = this.soffset = queryOperator.getSpecialClauseComponent().getSeriesOffset();
            int slimit = queryOperator.getSpecialClauseComponent().getSeriesLimit();
            this.currentLimit = slimit == 0 ? this.currentLimit : Math.min(slimit, this.currentLimit);
        }
    }

    private WildcardsRemover(boolean isPrefixMatch) {
        this.isPrefixMatch = isPrefixMatch;
    }

    public List<MeasurementPath> removeWildcardFrom(PartialPath path) throws LogicalOptimizeException {
        try {
            Pair pair = IoTDB.schemaProcessor.getMeasurementPathsWithAlias(path, this.currentLimit, this.currentOffset, this.isPrefixMatch, false);
            this.consumed += ((Integer)pair.right).intValue();
            this.currentOffset -= Math.min(this.currentOffset, (Integer)pair.right);
            this.currentLimit -= ((List)pair.left).size();
            return (List)pair.left;
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error occurred when removing star: " + e.getMessage());
        }
    }

    public List<List<Expression>> removeWildcardsFrom(List<Expression> expressions) throws LogicalOptimizeException {
        ArrayList extendedExpressions = new ArrayList();
        for (Expression originExpression : expressions) {
            ArrayList actualExpressions = new ArrayList();
            originExpression.removeWildcards(new WildcardsRemover(this.isPrefixMatch), actualExpressions);
            if (actualExpressions.isEmpty()) {
                return Collections.emptyList();
            }
            extendedExpressions.add(actualExpressions);
        }
        ArrayList actualExpressions = new ArrayList();
        ConcatPathOptimizer.cartesianProduct(extendedExpressions, actualExpressions, (int)0, new ArrayList());
        ArrayList<List<Expression>> remainingExpressions = new ArrayList<List<Expression>>();
        for (List actualExpression : actualExpressions) {
            if (this.currentOffset != 0) {
                --this.currentOffset;
                continue;
            }
            if (this.currentLimit == 0) break;
            --this.currentLimit;
            remainingExpressions.add(actualExpression);
        }
        this.consumed += actualExpressions.size();
        return remainingExpressions;
    }

    public boolean checkIfPathNumberIsOverLimit(List<ResultColumn> resultColumns) throws PathNumOverLimitException {
        if (resultColumns.size() > IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum()) {
            throw new PathNumOverLimitException();
        }
        return this.currentLimit == 0;
    }

    public void checkIfSoffsetIsExceeded(List<ResultColumn> resultColumns) throws LogicalOptimizeException {
        if (this.consumed == 0 ? this.soffset != 0 : resultColumns.isEmpty()) {
            throw new LogicalOptimizeException(String.format("The value of SOFFSET (%d) is equal to or exceeds the number of sequences (%d) that can actually be returned.", this.soffset, this.consumed));
        }
    }
}

