/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.service.ConfigNodeCommandLine;
import org.apache.iotdb.confignode.service.ConfigNodeMBean;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCService;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNode
implements ConfigNodeMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNode.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int SCHEDULE_WAITING_RETRY_NUM = 20;
    private static final int SEED_CONFIG_NODE_ID = 0;
    private static final int INIT_NON_SEED_CONFIG_NODE_ID = -1;
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.confignode.service", "type", "ConfigNode");
    private final RegisterManager registerManager = new RegisterManager();
    private ConfigManager configManager;

    private ConfigNode() {
    }

    public static void main(String[] args) {
        new ConfigNodeCommandLine().doMain(args);
    }

    public void active() {
        LOGGER.info("Activating {}...", (Object)"IoTDB-ConfigNode");
        try {
            this.setUpInternalServices();
            this.initConfigManager();
            if (SystemPropertiesUtils.isRestarted()) {
                LOGGER.info("{} is in restarting process...", (Object)"IoTDB-ConfigNode");
                CONF.setConfigNodeId(SystemPropertiesUtils.loadConfigNodeId());
                this.configManager.initConsensusManager();
                this.setUpRPCService();
                LOGGER.info("{} has successfully started and joined the cluster.", (Object)"IoTDB-ConfigNode");
                return;
            }
            if (ConfigNodeDescriptor.getInstance().isSeedConfigNode()) {
                LOGGER.info("The current {} is now starting as the Seed-ConfigNode.", (Object)"IoTDB-ConfigNode");
                CONF.setConfigNodeId(0);
                this.configManager.initConsensusManager();
                SystemPropertiesUtils.storeSystemParameters();
                this.configManager.getNodeManager().applyConfigNode(new TConfigNodeLocation(0, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())));
                this.setUpRPCService();
                LOGGER.info("{} has successfully started and joined the cluster.", (Object)"IoTDB-ConfigNode");
                return;
            }
            this.setUpRPCService();
            this.registerConfigNode();
            LOGGER.info("{} has registered successfully. Waiting for the leader's scheduling to join the cluster.", (Object)"IoTDB-ConfigNode");
            boolean isJoinedCluster = false;
            for (int retry = 0; retry < 20; ++retry) {
                if (this.configManager.getConsensusManager().getConsensusImpl().getAllConsensusGroupIds().size() > 0) {
                    isJoinedCluster = true;
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Waiting leader's scheduling is interrupted.");
                }
            }
            if (!isJoinedCluster) {
                LOGGER.error("The current ConfigNode can't joined the cluster because leader's scheduling failed. The possible cause is that the ip:port configuration is incorrect.");
                this.stop();
            }
        }
        catch (IOException | StartupException e) {
            LOGGER.error("Meet error while starting up.", e);
            try {
                this.stop();
            }
            catch (IOException e2) {
                LOGGER.error("Meet error when stop ConfigNode!", e);
            }
        }
    }

    private void initConfigManager() {
        try {
            this.configManager = new ConfigManager();
        }
        catch (IOException e) {
            LOGGER.error("Can't start ConfigNode consensus group!", (Throwable)e);
            try {
                this.stop();
            }
            catch (IOException e2) {
                LOGGER.error("Meet error when stop ConfigNode!", (Throwable)e);
            }
        }
        this.configManager.addMetrics();
        LOGGER.info("Successfully initialize ConfigManager.");
    }

    private void setUpInternalServices() throws StartupException, IOException {
        this.registerManager.register((IService)new JMXService());
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        this.registerManager.register((IService)UDFExecutableManager.setupAndGetInstance((String)CONF.getTemporaryLibDir(), (String)CONF.getUdfLibDir()));
        this.registerManager.register((IService)UDFClassLoaderManager.setupAndGetInstance((String)CONF.getUdfLibDir()));
        this.registerManager.register((IService)UDFRegistrationService.setupAndGetInstance((String)CONF.getSystemUdfDir()));
        this.registerManager.register((IService)MetricService.getInstance());
        LOGGER.info("Successfully setup internal services.");
    }

    private void registerConfigNode() throws StartupException, IOException {
        TConfigNodeRegisterReq req = new TConfigNodeRegisterReq(new TConfigNodeLocation(-1, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())), CONF.getDataRegionConsensusProtocolClass(), CONF.getSchemaRegionConsensusProtocolClass(), CONF.getSeriesPartitionSlotNum(), CONF.getSeriesPartitionExecutorClass(), CommonDescriptor.getInstance().getConfig().getDefaultTTL(), CONF.getTimePartitionInterval(), CONF.getSchemaReplicationFactor(), CONF.getSchemaRegionPerDataNode(), CONF.getDataReplicationFactor(), CONF.getDataRegionPerProcessor(), CONF.getReadConsistencyLevel(), CommonDescriptor.getInstance().getConfig().getDiskSpaceWarningThreshold());
        TEndPoint targetConfigNode = CONF.getTargetConfigNode();
        if (targetConfigNode == null) {
            LOGGER.error("The targetConfigNode setting in conf is empty");
            throw new StartupException("The targetConfigNode setting in conf is empty");
        }
        for (int retry = 0; retry < 3; ++retry) {
            TSStatus status;
            TConfigNodeRegisterResp resp = null;
            Object obj = SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(targetConfigNode, req, ConfigNodeRequestType.REGISTER_CONFIG_NODE);
            if (obj instanceof TConfigNodeRegisterResp) {
                resp = (TConfigNodeRegisterResp)obj;
                status = resp.getStatus();
            } else {
                status = (TSStatus)obj;
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                CONF.setConfigNodeId(resp.getConfigNodeId());
                this.configManager.initConsensusManager();
                return;
            }
            if (status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
                targetConfigNode = status.getRedirectNode();
                LOGGER.info("ConfigNode need redirect to  {}.", (Object)targetConfigNode);
            } else if (status.getCode() == TSStatusCode.ERROR_GLOBAL_CONFIG.getStatusCode()) {
                LOGGER.error(status.getMessage());
                throw new StartupException("Configuration are not consistent!");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new StartupException("Register ConfigNode failed!");
            }
        }
        LOGGER.error("The current ConfigNode can't send register request to the Seed-ConfigNode after all retries!");
        this.stop();
    }

    private void setUpRPCService() throws StartupException {
        ConfigNodeRPCService configNodeRPCService = new ConfigNodeRPCService();
        ConfigNodeRPCServiceProcessor configNodeRPCServiceProcessor = new ConfigNodeRPCServiceProcessor(this.configManager);
        configNodeRPCService.initSyncedServiceImpl(configNodeRPCServiceProcessor);
        this.registerManager.register((IService)configNodeRPCService);
    }

    public void stop() throws IOException {
        LOGGER.info("Deactivating {}...", (Object)"IoTDB-ConfigNode");
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        if (this.configManager != null) {
            this.configManager.close();
        }
        LOGGER.info("{} is deactivated.", (Object)"IoTDB-ConfigNode");
        System.exit(-1);
    }

    public static ConfigNode getInstance() {
        return ConfigNodeHolder.INSTANCE;
    }

    private static class ConfigNodeHolder {
        private static final ConfigNode INSTANCE = new ConfigNode();

        private ConfigNodeHolder() {
        }
    }
}

