/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.scheduler;

import java.util.ArrayDeque;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;

public class LockQueue {
    private final ArrayDeque<Procedure> deque = new ArrayDeque();
    private Procedure<?> lockOwnerProcedure = null;

    public boolean tryLock(Procedure<?> procedure) {
        if (this.lockOwnerProcedure == null) {
            this.lockOwnerProcedure = procedure;
            return true;
        }
        return procedure.getProcId() == this.lockOwnerProcedure.getProcId();
    }

    public boolean releaseLock(Procedure<?> procedure) {
        if (this.lockOwnerProcedure == null || this.lockOwnerProcedure.getProcId() != procedure.getProcId()) {
            return false;
        }
        this.lockOwnerProcedure = null;
        return true;
    }

    public void waitProcedure(Procedure procedure) {
        this.deque.addLast(procedure);
    }

    public int wakeWaitingProcedures(ProcedureScheduler procedureScheduler) {
        int count = this.deque.size();
        while (!this.deque.isEmpty()) {
            procedureScheduler.addFront(this.deque.pollFirst());
        }
        this.deque.clear();
        return count;
    }
}

