/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.sync.AbstractOperatePipeProcedure;
import org.apache.iotdb.confignode.procedure.state.sync.OperatePipeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartPipeProcedure
extends AbstractOperatePipeProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartPipeProcedure.class);
    private String pipeName;

    public StartPipeProcedure() {
    }

    public StartPipeProcedure(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    boolean executeCheckCanSkip(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to start PIPE [{}]", (Object)this.pipeName);
        PipeInfo pipeInfo = env.getConfigManager().getSyncManager().getPipeInfo(this.pipeName);
        return pipeInfo.getStatus().equals((Object)PipeStatus.RUNNING);
    }

    @Override
    void executePreOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to pre-start PIPE [{}] on Config Nodes", (Object)this.pipeName);
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeName, PipeStatus.PREPARE_START);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    void executeOperatePipeOnDataNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to broadcast start PIPE [{}] on Data Nodes", (Object)this.pipeName);
        TSStatus status = RpcUtils.squashResponseStatusList(env.getConfigManager().getSyncManager().operatePipeOnDataNodes(this.pipeName, SyncOperation.START_PIPE));
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Fail to start PIPE [%s] on Data Nodes because %s", this.pipeName, status.getMessage()));
        }
    }

    @Override
    void executeOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to start PIPE [{}] on Config Nodes", (Object)this.pipeName);
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeName, PipeStatus.RUNNING);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    SyncOperation getOperation() {
        return SyncOperation.START_PIPE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.START_PIPE_PROCEDURE.ordinal());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartPipeProcedure that = (StartPipeProcedure)o;
        return Objects.equals(this.pipeName, that.pipeName);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName);
    }
}

