/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.sync.OperatePipeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOperatePipeProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, OperatePipeState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperatePipeProcedure.class);
    private static final int retryThreshold = 3;

    AbstractOperatePipeProcedure() {
    }

    abstract boolean executeCheckCanSkip(ConfigNodeProcedureEnv var1) throws PipeException;

    abstract void executePreOperatePipeOnConfigNode(ConfigNodeProcedureEnv var1) throws PipeException;

    abstract void executeOperatePipeOnDataNode(ConfigNodeProcedureEnv var1) throws PipeException;

    abstract void executeOperatePipeOnConfigNode(ConfigNodeProcedureEnv var1) throws PipeException;

    abstract SyncOperation getOperation();

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, OperatePipeState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block10: {
            try {
                switch (state) {
                    case OPERATE_CHECK: {
                        if (this.executeCheckCanSkip(env)) {
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                        this.setNextState(OperatePipeState.PRE_OPERATE_PIPE_CONFIGNODE);
                        break;
                    }
                    case PRE_OPERATE_PIPE_CONFIGNODE: {
                        this.executePreOperatePipeOnConfigNode(env);
                        this.setNextState(OperatePipeState.OPERATE_PIPE_DATANODE);
                        break;
                    }
                    case OPERATE_PIPE_DATANODE: {
                        this.executeOperatePipeOnDataNode(env);
                        this.setNextState(OperatePipeState.OPERATE_PIPE_CONFIGNODE);
                        break;
                    }
                    case OPERATE_PIPE_CONFIGNODE: {
                        this.executeOperatePipeOnConfigNode(env);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (PipeException e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in OperatePipeProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to {} at state [{}]", new Object[]{this.getOperation(), state, e});
                if (this.getCycles() <= 3) break block10;
                this.setFailure(new ProcedureException(String.format("Fail to %s because %s", this.getOperation().name(), e.getMessage())));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv env) {
        env.getSchedulerLock().lock();
        try {
            if (env.getPipeLock().tryLock(this)) {
                LOGGER.info("procedureId {} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            env.getPipeLock().waitProcedure(this);
            LOGGER.info("procedureId {} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            env.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv env) {
        env.getSchedulerLock().lock();
        try {
            LOGGER.info("procedureId {} release lock.", (Object)this.getProcId());
            if (env.getPipeLock().releaseLock(this)) {
                env.getPipeLock().wakeWaitingProcedures(env.getScheduler());
            }
        }
        finally {
            env.getSchedulerLock().unlock();
        }
    }

    @Override
    protected OperatePipeState getState(int stateId) {
        return OperatePipeState.values()[stateId];
    }

    @Override
    protected int getStateId(OperatePipeState state) {
        return state.ordinal();
    }

    @Override
    protected OperatePipeState getInitialState() {
        return OperatePipeState.OPERATE_CHECK;
    }
}

