/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.statemachine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.persistence.partition.RegionDeleteTask;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.DeleteStorageGroupState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStorageGroupProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteStorageGroupState> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteStorageGroupProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TStorageGroupSchema deleteSgSchema;

    public DeleteStorageGroupProcedure() {
    }

    public DeleteStorageGroupProcedure(TStorageGroupSchema deleteSgSchema) {
        this.deleteSgSchema = deleteSgSchema;
    }

    public TStorageGroupSchema getDeleteSgSchema() {
        return this.deleteSgSchema;
    }

    public void setDeleteSgSchema(TStorageGroupSchema deleteSgSchema) {
        this.deleteSgSchema = deleteSgSchema;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteStorageGroupState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        block12: {
            if (this.deleteSgSchema == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case DELETE_STORAGE_GROUP_PREPARE: {
                        this.setNextState(DeleteStorageGroupState.DELETE_PRE);
                        break;
                    }
                    case DELETE_PRE: {
                        LOG.info("Pre delete for Storage group {}", (Object)this.deleteSgSchema.getName());
                        env.preDelete(PreDeleteStorageGroupPlan.PreDeleteType.EXECUTE, this.deleteSgSchema.getName());
                        this.setNextState(DeleteStorageGroupState.INVALIDATE_CACHE);
                        break;
                    }
                    case INVALIDATE_CACHE: {
                        LOG.info("Invalidate cache of {}", (Object)this.deleteSgSchema.getName());
                        if (env.invalidateCache(this.deleteSgSchema.getName())) {
                            this.setNextState(DeleteStorageGroupState.DELETE_CONFIG);
                            break;
                        }
                        this.setFailure(new ProcedureException("Invalidate cache failed"));
                        break;
                    }
                    case DELETE_CONFIG: {
                        LOG.info("Delete config info of {}", (Object)this.deleteSgSchema.getName());
                        OfferRegionMaintainTasksPlan offerPlan = new OfferRegionMaintainTasksPlan();
                        List<TRegionReplicaSet> regionReplicaSets = env.getAllReplicaSets(this.deleteSgSchema.getName());
                        regionReplicaSets.forEach(regionReplicaSet -> {
                            regionReplicaSet.getDataNodeLocations().forEach(targetDataNode -> offerPlan.appendRegionMaintainTask(new RegionDeleteTask((TDataNodeLocation)targetDataNode, regionReplicaSet.getRegionId())));
                            env.getConfigManager().getPartitionManager().removeRegionGroupCache(regionReplicaSet.getRegionId());
                        });
                        env.getConfigManager().getConsensusManager().write(offerPlan);
                        TSStatus status = env.deleteConfig(this.deleteSgSchema.getName());
                        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                        if (this.getCycles() <= 5) break;
                        this.setFailure(new ProcedureException("Delete config info id failed"));
                    }
                }
            }
            catch (IOException | TException e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Delete storage group failed " + (Object)((Object)state)));
                }
                LOG.error("Retriable error trying to delete storage group {}, state {}", new Object[]{this.deleteSgSchema.getName(), state, e});
                if (this.getCycles() <= 5) break block12;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteStorageGroupState state) throws IOException, InterruptedException {
        switch (state) {
            case DELETE_PRE: 
            case INVALIDATE_CACHE: {
                LOG.info("Rollback preDeleted:{}", (Object)this.deleteSgSchema.getName());
                env.preDelete(PreDeleteStorageGroupPlan.PreDeleteType.ROLLBACK, this.deleteSgSchema.getName());
            }
        }
    }

    @Override
    protected boolean isRollbackSupported(DeleteStorageGroupState state) {
        switch (state) {
            case DELETE_PRE: 
            case INVALIDATE_CACHE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected DeleteStorageGroupState getState(int stateId) {
        return DeleteStorageGroupState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteStorageGroupState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected DeleteStorageGroupState getInitialState() {
        return DeleteStorageGroupState.DELETE_STORAGE_GROUP_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.DELETE_STORAGE_GROUP_PROCEDURE.ordinal());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTStorageGroupSchema((TStorageGroupSchema)this.deleteSgSchema, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.deleteSgSchema = ThriftConfigNodeSerDeUtils.deserializeTStorageGroupSchema((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize DeleteStorageGroupProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof DeleteStorageGroupProcedure) {
            DeleteStorageGroupProcedure thatProc = (DeleteStorageGroupProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.deleteSgSchema.equals(this.getDeleteSgSchema());
        }
        return false;
    }
}

