/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.client.sync.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.exception.AddConsensusGroupException;
import org.apache.iotdb.confignode.exception.AddPeerException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.RegionHeartbeatSample;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.mpp.rpc.thrift.TActiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInactiveTriggerInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateConfigNodeGroupReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeProcedureEnv {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigNodeProcedureEnv.class);
    private final LockQueue nodeLock = new LockQueue();
    private final LockQueue pipeLock = new LockQueue();
    private final ReentrantLock schedulerLock = new ReentrantLock();
    private final ConfigManager configManager;
    private final ProcedureScheduler scheduler;
    private final DataNodeRemoveHandler dataNodeRemoveHandler;
    private final ReentrantLock removeConfigNodeLock;

    public ConfigNodeProcedureEnv(ConfigManager configManager, ProcedureScheduler scheduler) {
        this.configManager = configManager;
        this.scheduler = scheduler;
        this.dataNodeRemoveHandler = new DataNodeRemoveHandler(configManager);
        this.removeConfigNodeLock = new ReentrantLock();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TSStatus deleteConfig(String name) {
        DeleteStorageGroupPlan deleteStorageGroupPlan = new DeleteStorageGroupPlan(name);
        return this.getClusterSchemaManager().deleteStorageGroup(deleteStorageGroupPlan);
    }

    public void preDelete(PreDeleteStorageGroupPlan.PreDeleteType preDeleteType, String deleteSgName) {
        this.getPartitionManager().preDeleteStorageGroup(deleteSgName, preDeleteType);
    }

    public boolean invalidateCache(String storageGroupName) throws IOException, TException {
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        TInvalidateCacheReq invalidateCacheReq = new TInvalidateCacheReq();
        invalidateCacheReq.setStorageGroup(true);
        invalidateCacheReq.setFullPath(storageGroupName);
        for (TDataNodeConfiguration dataNodeConfiguration : allDataNodes) {
            TSStatus invalidateSchemaStatus = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, DataNodeRequestType.INVALIDATE_SCHEMA_CACHE);
            TSStatus invalidatePartitionStatus = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, DataNodeRequestType.INVALIDATE_PARTITION_CACHE);
            if (this.verifySucceed(invalidatePartitionStatus, invalidateSchemaStatus)) continue;
            LOG.error("Invalidate cache failed, invalidate partition cache status is {}, invalidate schema cache status is {}", (Object)invalidatePartitionStatus, (Object)invalidateSchemaStatus);
            return false;
        }
        return true;
    }

    public boolean verifySucceed(TSStatus ... status) {
        return Arrays.stream(status).allMatch(tsStatus -> tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public void addConsensusGroup(TConfigNodeLocation tConfigNodeLocation) throws AddConsensusGroupException {
        ArrayList<TConfigNodeLocation> configNodeLocations = new ArrayList<TConfigNodeLocation>(this.configManager.getNodeManager().getRegisteredConfigNodes());
        configNodeLocations.add(tConfigNodeLocation);
        TSStatus status = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), new TAddConsensusGroupReq(configNodeLocations), ConfigNodeRequestType.ADD_CONSENSUS_GROUP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new AddConsensusGroupException(tConfigNodeLocation);
        }
    }

    public void addConfigNodePeer(TConfigNodeLocation configNodeLocation) throws AddPeerException {
        this.configManager.getConsensusManager().addConfigNodePeer(configNodeLocation);
    }

    public void removeConfigNodePeer(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        this.removeConfigNodeLock.tryLock();
        try {
            TSStatus tsStatus = this.getConsensusManager().removeConfigNodePeer(tConfigNodeLocation) ? this.getConsensusManager().write(new RemoveConfigNodePlan(tConfigNodeLocation)).getStatus() : new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because update ConsensusGroup peer information failed.");
            if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new ProcedureException(tsStatus.getMessage());
            }
        }
        finally {
            this.removeConfigNodeLock.unlock();
        }
    }

    public void deleteConfigNodePeer(TConfigNodeLocation removedConfigNode) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(removedConfigNode.getInternalEndPoint(), removedConfigNode, ConfigNodeRequestType.DELETE_CONFIG_NODE_PEER);
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
    }

    public void stopConfigNode(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), tConfigNodeLocation, ConfigNodeRequestType.STOP_CONFIG_NODE);
        this.getNodeManager().removeNodeCache(tConfigNodeLocation.getConfigNodeId());
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
    }

    public void applyConfigNode(TConfigNodeLocation configNodeLocation) {
        this.configManager.getNodeManager().applyConfigNode(configNodeLocation);
    }

    public void notifyRegisterSuccess(TConfigNodeLocation configNodeLocation) {
        SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(configNodeLocation.getInternalEndPoint(), null, ConfigNodeRequestType.NOTIFY_REGISTER_SUCCESS);
    }

    public void broadCastTheLatestConfigNodeGroup() {
        List<TConfigNodeLocation> registeredConfigNodes = this.configManager.getNodeManager().getRegisteredConfigNodes();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.BROADCAST_LATEST_CONFIG_NODE_GROUP, new TUpdateConfigNodeGroupReq(registeredConfigNodes), this.configManager.getNodeManager().getRegisteredDataNodeLocations());
        LOG.info("Begin to broadcast the latest configNodeGroup: {}", registeredConfigNodes);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        LOG.info("Broadcast the latest configNodeGroup finished.");
    }

    public void markDataNodeAsRemovingAndBroadCast(TDataNodeLocation dataNodeLocation) {
        this.configManager.getNodeManager().setNodeRemovingStatus(dataNodeLocation);
        this.configManager.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> doRegionCreation(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        AsyncClientHandler<TCreateSchemaRegionReq, TSStatus> clientHandler;
        switch (consensusGroupType) {
            case SchemaRegion: {
                clientHandler = this.getCreateSchemaRegionClientHandler(createRegionGroupsPlan);
                break;
            }
            default: {
                clientHandler = this.getCreateDataRegionClientHandler(createRegionGroupsPlan);
            }
        }
        if (clientHandler.getRequestIndices().isEmpty()) {
            return new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        }
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        int requestId = 0;
        Map<Integer, TSStatus> responseMap = clientHandler.getResponseMap();
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (List<TRegionReplicaSet> regionReplicaSets : createRegionGroupsPlan.getRegionGroupMap().values()) {
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    if (responseMap.get(requestId).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        failedRegions.computeIfAbsent(regionReplicaSet.getRegionId(), empty -> new TRegionReplicaSet().setRegionId(regionReplicaSet.getRegionId())).addToDataNodeLocations(dataNodeLocation);
                    }
                    ++requestId;
                }
            }
        }
        return failedRegions;
    }

    private AsyncClientHandler<TCreateSchemaRegionReq, TSStatus> getCreateSchemaRegionClientHandler(CreateRegionGroupsPlan createRegionGroupsPlan) {
        AsyncClientHandler<TCreateSchemaRegionReq, TSStatus> clientHandler = new AsyncClientHandler<TCreateSchemaRegionReq, TSStatus>(DataNodeRequestType.CREATE_SCHEMA_REGION);
        int requestId = 0;
        for (Map.Entry<String, List<TRegionReplicaSet>> sgRegionsEntry : createRegionGroupsPlan.getRegionGroupMap().entrySet()) {
            String storageGroup = sgRegionsEntry.getKey();
            List<TRegionReplicaSet> regionReplicaSets = sgRegionsEntry.getValue();
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    clientHandler.putRequest(requestId, this.genCreateSchemaRegionReq(storageGroup, regionReplicaSet));
                    clientHandler.putDataNodeLocation(requestId, dataNodeLocation);
                    ++requestId;
                }
            }
        }
        return clientHandler;
    }

    private AsyncClientHandler<TCreateDataRegionReq, TSStatus> getCreateDataRegionClientHandler(CreateRegionGroupsPlan createRegionGroupsPlan) {
        Map<String, Long> ttlMap = this.getTTLMap(createRegionGroupsPlan);
        AsyncClientHandler<TCreateDataRegionReq, TSStatus> clientHandler = new AsyncClientHandler<TCreateDataRegionReq, TSStatus>(DataNodeRequestType.CREATE_DATA_REGION);
        int requestId = 0;
        for (Map.Entry<String, List<TRegionReplicaSet>> sgRegionsEntry : createRegionGroupsPlan.getRegionGroupMap().entrySet()) {
            String storageGroup = sgRegionsEntry.getKey();
            List<TRegionReplicaSet> regionReplicaSets = sgRegionsEntry.getValue();
            long ttl = ttlMap.get(storageGroup);
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    clientHandler.putRequest(requestId, this.genCreateDataRegionReq(storageGroup, regionReplicaSet, ttl));
                    clientHandler.putDataNodeLocation(requestId, dataNodeLocation);
                    ++requestId;
                }
            }
        }
        return clientHandler;
    }

    private Map<String, Long> getTTLMap(CreateRegionGroupsPlan createRegionGroupsPlan) {
        HashMap<String, Long> ttlMap = new HashMap<String, Long>();
        for (String storageGroup : createRegionGroupsPlan.getRegionGroupMap().keySet()) {
            try {
                ttlMap.put(storageGroup, this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup).getTTL());
            }
            catch (StorageGroupNotExistsException e) {
                LOG.error("StorageGroup doesn't exist", (Throwable)e);
            }
        }
        return ttlMap;
    }

    private TCreateSchemaRegionReq genCreateSchemaRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        TCreateSchemaRegionReq req = new TCreateSchemaRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        return req;
    }

    private TCreateDataRegionReq genCreateDataRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet, long TTL) {
        TCreateDataRegionReq req = new TCreateDataRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        req.setTtl(TTL);
        return req;
    }

    public long getTTL(String storageGroup) throws StorageGroupNotExistsException {
        return this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup).getTTL();
    }

    public void persistAndBroadcastRegionGroup(CreateRegionGroupsPlan createRegionGroupsPlan) {
        this.getConsensusManager().write(createRegionGroupsPlan);
        this.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public void buildRegionGroupCache(TConsensusGroupId regionGroupId, Map<Integer, RegionStatus> regionStatusMap) {
        long currentTime = System.currentTimeMillis();
        regionStatusMap.forEach((dataNodeId, regionStatus) -> this.getPartitionManager().cacheHeartbeatSample(regionGroupId, new RegionHeartbeatSample(currentTime, currentTime, (int)dataNodeId, false, (RegionStatus)regionStatus)));
        this.getPartitionManager().getRegionGroupCacheMap().get(regionGroupId).updateRegionStatistics();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String storageGroup) {
        return this.getPartitionManager().getAllReplicaSets(storageGroup);
    }

    public List<TSStatus> createTriggerOnDataNodes(TriggerInformation triggerInformation, Binary jarFile) throws IOException {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TCreateTriggerInstanceReq request = new TCreateTriggerInstanceReq(triggerInformation.serialize(), ByteBuffer.wrap(jarFile.getValues()));
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> dropTriggerOnDataNodes(String triggerName, boolean needToDeleteJarFile) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TDropTriggerInstanceReq request = new TDropTriggerInstanceReq(triggerName, needToDeleteJarFile);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.DROP_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> activeTriggerOnDataNodes(String triggerName) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TActiveTriggerInstanceReq request = new TActiveTriggerInstanceReq(triggerName);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.ACTIVE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public List<TSStatus> inactiveTriggerOnDataNodes(String triggerName) {
        NodeManager nodeManager = this.configManager.getNodeManager();
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = nodeManager.getRegisteredDataNodeLocations();
        TInactiveTriggerInstanceReq request = new TInactiveTriggerInstanceReq(triggerName);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.INACTIVE_TRIGGER_INSTANCE, request, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        return clientHandler.getResponseList();
    }

    public LockQueue getNodeLock() {
        return this.nodeLock;
    }

    public LockQueue getPipeLock() {
        return this.pipeLock;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public LockQueue getRegionMigrateLock() {
        return this.dataNodeRemoveHandler.getRegionMigrateLock();
    }

    public ReentrantLock getSchedulerLock() {
        return this.schedulerLock;
    }

    public DataNodeRemoveHandler getDataNodeRemoveHandler() {
        return this.dataNodeRemoveHandler;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

