/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.sync;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeNotExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.sync.metadata.SyncMetadata;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.ShowPipePlan;
import org.apache.iotdb.confignode.consensus.response.PipeResp;
import org.apache.iotdb.confignode.consensus.response.PipeSinkResp;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSyncInfo
implements SnapshotProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ClusterSyncInfo.class);
    private final SyncMetadata syncMetadata = new SyncMetadata();

    public void checkAddPipeSink(String pipeSinkName) throws PipeSinkException {
        this.syncMetadata.checkAddPipeSink(pipeSinkName);
    }

    public TSStatus addPipeSink(CreatePipeSinkPlan plan) {
        TSStatus status = new TSStatus();
        try {
            this.syncMetadata.addPipeSink(SyncPipeUtil.parseTPipeSinkInfoAsPipeSink((TPipeSinkInfo)plan.getPipeSinkInfo()));
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (PipeSinkException e) {
            LOGGER.error("failed to execute CreatePipeSinkPlan {} on ClusterSyncInfo", (Object)plan, (Object)e);
            status.setCode(TSStatusCode.PIPESINK_ERROR.getStatusCode());
            LOGGER.error(e.getMessage());
        }
        return status;
    }

    public void checkDropPipeSink(String pipeSinkName) throws PipeSinkException {
        this.syncMetadata.checkDropPipeSink(pipeSinkName);
    }

    public TSStatus dropPipeSink(DropPipeSinkPlan plan) {
        this.syncMetadata.dropPipeSink(plan.getPipeSinkName());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public PipeSinkResp getPipeSink(GetPipeSinkPlan plan) {
        PipeSinkResp resp = new PipeSinkResp();
        if (StringUtils.isEmpty((CharSequence)plan.getPipeSinkName())) {
            resp.setPipeSinkList(this.syncMetadata.getAllPipeSink());
        } else {
            resp.setPipeSinkList(Collections.singletonList(this.syncMetadata.getPipeSink(plan.getPipeSinkName())));
        }
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return resp;
    }

    public void checkAddPipe(PipeInfo pipeInfo) throws PipeException {
        this.syncMetadata.checkAddPipe(pipeInfo);
    }

    public TSStatus preCreatePipe(PreCreatePipePlan physicalPlan) {
        this.syncMetadata.addPipe(physicalPlan.getPipeInfo());
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus operatePipe(SetPipeStatusPlan physicalPlan) {
        TSStatus status = new TSStatus();
        try {
            this.syncMetadata.setPipeStatus(physicalPlan.getPipeName(), physicalPlan.getPipeStatus());
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (PipeException e) {
            LOGGER.error("failed to execute OperatePipePlan {} on ClusterSyncInfo", (Object)physicalPlan, (Object)e);
            status.setCode(TSStatusCode.PIPE_ERROR.getStatusCode());
            LOGGER.error(e.getMessage());
        }
        return status;
    }

    public PipeResp showPipe(ShowPipePlan plan) {
        PipeResp resp = new PipeResp();
        List allPipeInfos = this.syncMetadata.getAllPipeInfos();
        if (StringUtils.isEmpty((CharSequence)plan.getPipeName())) {
            resp.setPipeInfoList(allPipeInfos);
        } else {
            ArrayList<PipeInfo> pipeInfoList = new ArrayList<PipeInfo>();
            for (PipeInfo pipeInfo : allPipeInfos) {
                if (!plan.getPipeName().equals(pipeInfo.getPipeName())) continue;
                pipeInfoList.add(pipeInfo);
            }
            resp.setPipeInfoList(pipeInfoList);
        }
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return resp;
    }

    public PipeInfo getPipeInfo(String pipeName) throws PipeNotExistException {
        PipeInfo pipeInfo = this.syncMetadata.getRunningPipeInfo();
        if (pipeInfo == null || !pipeInfo.getPipeName().equals(pipeName)) {
            throw new PipeNotExistException(pipeName);
        }
        return pipeInfo;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.syncMetadata.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.syncMetadata.processLoadSnapshot(snapshotDir);
    }
}

