/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.AdjustMaxRegionGroupCountPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.consensus.response.TemplateInfoResp;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.persistence.schema.TemplateTable;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.metadata.mtree.ConfigMTree;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaInfo.class);
    private final ReentrantReadWriteLock storageGroupReadWriteLock = new ReentrantReadWriteLock();
    private final ConfigMTree mTree;
    private final String snapshotFileName = "cluster_schema.bin";
    private final TemplateTable templateTable;

    public ClusterSchemaInfo() throws IOException {
        try {
            this.mTree = new ConfigMTree();
            this.templateTable = new TemplateTable();
        }
        catch (MetadataException e) {
            LOGGER.error("Can't construct StorageGroupInfo", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setStorageGroup(SetStorageGroupPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            TStorageGroupSchema storageGroupSchema = plan.getSchema();
            PartialPath partialPathName = new PartialPath(storageGroupSchema.getName());
            this.mTree.setStorageGroup(partialPathName);
            this.mTree.getStorageGroupNodeByStorageGroupPath(partialPathName).setStorageGroupSchema(storageGroupSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteStorageGroup(DeleteStorageGroupPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            String storageGroup = plan.getName();
            PartialPath partialPathName = new PartialPath(storageGroup);
            this.mTree.deleteStorageGroup(partialPathName);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.warn("Storage group not exist", (Throwable)e);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Storage group not exist: " + e.getMessage());
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStorageGroupResp countMatchedStorageGroups(CountStorageGroupPlan plan) {
        CountStorageGroupResp result = new CountStorageGroupResp();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(plan.getStorageGroupPattern());
            result.setCount(this.mTree.getStorageGroupNum(patternPath, false));
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroup name: " + e.getMessage()));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageGroupSchemaResp getMatchedStorageGroupSchemas(GetStorageGroupPlan plan) {
        StorageGroupSchemaResp result = new StorageGroupSchemaResp();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            HashMap<String, TStorageGroupSchema> schemaMap = new HashMap<String, TStorageGroupSchema>();
            PartialPath patternPath = new PartialPath(plan.getStorageGroupPattern());
            List matchedPaths = this.mTree.getMatchedStorageGroups(patternPath, false);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema());
            }
            result.setSchemaMap(schemaMap);
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroup name: " + e.getMessage()));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTTL(SetTTLPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath patternPath = new PartialPath(plan.getStorageGroupPathPattern());
            List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
            if (matchedPaths.size() != 0) {
                for (PartialPath path : matchedPaths) {
                    this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTTL(plan.getTTL());
                }
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
                result.setMessage("StorageGroup does not exist");
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setSchemaReplicationFactor(plan.getSchemaReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setDataReplicationFactor(plan.getDataReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(plan.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTimePartitionInterval(plan.getTimePartitionInterval());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus adjustMaxRegionGroupCount(AdjustMaxRegionGroupCountPlan plan) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            for (Map.Entry<String, Pair<Integer, Integer>> entry : plan.getMaxRegionGroupCountMap().entrySet()) {
                PartialPath path = new PartialPath(entry.getKey());
                TStorageGroupSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
                storageGroupSchema.setMaxSchemaRegionGroupCount(((Integer)entry.getValue().getLeft()).intValue());
                storageGroupSchema.setMaxDataRegionGroupCount(((Integer)entry.getValue().getRight()).intValue());
            }
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStorageGroupNames() {
        ArrayList<String> storageGroups = new ArrayList<String>();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            List namePaths = this.mTree.getAllStorageGroupPaths();
            for (PartialPath path : namePaths) {
                storageGroups.add(path.getFullPath());
            }
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return storageGroups;
    }

    public void checkContainsStorageGroup(String storageName) throws MetadataException {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            this.mTree.checkStorageGroupAlreadySet(new PartialPath(storageName));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    public TStorageGroupSchema getMatchedStorageGroupSchemaByName(String storageGroup) throws StorageGroupNotExistsException {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            TStorageGroupSchema tStorageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(new PartialPath(storageGroup)).getStorageGroupSchema();
            return tStorageGroupSchema;
        }
        catch (MetadataException e) {
            throw new StorageGroupNotExistsException(storageGroup);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TStorageGroupSchema> getMatchedStorageGroupSchemasByName(List<String> rawPathList) {
        HashMap<String, TStorageGroupSchema> schemaMap = new HashMap<String, TStorageGroupSchema>();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            for (String rawPath : rawPathList) {
                PartialPath patternPath = new PartialPath(rawPath);
                List matchedPaths = this.mTree.getMatchedStorageGroups(patternPath, false);
                for (PartialPath path : matchedPaths) {
                    schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByPath(path).getStorageGroupSchema());
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error StorageGroup name", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRegionGroupCount(String storageGroup, TConsensusGroupType consensusGroupType) {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            PartialPath path = new PartialPath(storageGroup);
            TStorageGroupSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMaxSchemaRegionGroupCount();
                    return n;
                }
            }
            int n = storageGroupSchema.getMaxDataRegionGroupCount();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error StorageGroup name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.processMtreeTakeSnapshot(snapshotDir);
        return this.templateTable.processTakeSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMtreeTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, "cluster_schema.bin");
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
                 BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
                this.mTree.serialize((OutputStream)outputStream);
                outputStream.flush();
            }
            boolean bl = tmpFile.renameTo(snapshotFile);
            return bl;
        }
        finally {
            for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.processMtreeLoadSnapshot(snapshotDir);
        this.templateTable.processLoadSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMtreeLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, "cluster_schema.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.storageGroupReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.mTree.clear();
            this.mTree.deserialize((InputStream)bufferedInputStream);
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath partialPath, int level) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getNodesListInGivenLevel(partialPath, level, true, null);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in given level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath partialPath) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getChildNodePathInNextLevel(partialPath);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in next level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<String>, Set<PartialPath>> getChildNodeNameInNextLevel(PartialPath partialPath) {
        Pair matchedNamesInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedNamesInNextLevel = this.mTree.getChildNodeNameInNextLevel(partialPath);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched names in next level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedNamesInNextLevel;
    }

    public TSStatus createSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        try {
            Template template = createSchemaTemplatePlan.getTemplate();
            this.templateTable.createTemplate(template);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TemplateInfoResp getAllTemplates() {
        TemplateInfoResp result = new TemplateInfoResp();
        List<Template> resp = this.templateTable.getAllTemplate();
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTemplateList(resp);
        return result;
    }

    public TemplateInfoResp getTemplate(GetSchemaTemplatePlan getSchemaTemplatePlan) {
        TemplateInfoResp result = new TemplateInfoResp();
        ArrayList<Template> list = new ArrayList<Template>();
        try {
            list.add(this.templateTable.getTemplate(getSchemaTemplatePlan.getTemplateName()));
            result.setTemplateList(list);
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return result;
    }

    public synchronized TemplateInfoResp checkTemplateSettable(CheckTemplateSettablePlan checkTemplateSettablePlan) {
        PartialPath path;
        TemplateInfoResp resp = new TemplateInfoResp();
        try {
            path = new PartialPath(checkTemplateSettablePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            return resp;
        }
        try {
            this.mTree.checkTemplateOnPath(path);
            resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            resp.setTemplateList(Collections.singletonList(this.templateTable.getTemplate(checkTemplateSettablePlan.getName())));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return resp;
    }

    public synchronized TSStatus setSchemaTemplate(SetSchemaTemplatePlan setSchemaTemplatePlan) {
        PartialPath path;
        try {
            path = new PartialPath(setSchemaTemplatePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        try {
            int templateId = this.templateTable.getTemplate(setSchemaTemplatePlan.getName()).getId();
            this.mTree.getNodeWithAutoCreate(path).setSchemaTemplateId(templateId);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public PathInfoResp getPathsSetTemplate(GetPathsSetTemplatePlan getPathsSetTemplatePlan) {
        TSStatus status;
        PathInfoResp pathInfoResp = new PathInfoResp();
        try {
            int templateId = this.templateTable.getTemplate(getPathsSetTemplatePlan.getName()).getId();
            pathInfoResp.setPathList(this.mTree.getPathsSetOnTemplate(templateId));
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            status = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        pathInfoResp.setStatus(status);
        return pathInfoResp;
    }

    public AllTemplateSetInfoResp getAllTemplateSetInfo() {
        List<Template> templateList = this.templateTable.getAllTemplate();
        HashMap<Integer, List> templateSetInfo = new HashMap<Integer, List>();
        for (Template template : templateList) {
            int id = template.getId();
            try {
                List pathList = this.mTree.getPathsSetOnTemplate(id);
                if (pathList.isEmpty()) continue;
                templateSetInfo.put(id, pathList);
            }
            catch (MetadataException e) {
                LOGGER.error("Error occurred when get paths set on template {}", (Object)id, (Object)e);
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)templateSetInfo.size(), (OutputStream)outputStream);
            for (Template template : templateList) {
                if (!templateSetInfo.containsKey(template.getId())) continue;
                template.serialize((OutputStream)outputStream);
                List pathsSetTemplate = (List)templateSetInfo.get(template.getId());
                ReadWriteIOUtils.write((int)pathsSetTemplate.size(), (OutputStream)outputStream);
                for (String path : pathsSetTemplate) {
                    ReadWriteIOUtils.write((String)path, (OutputStream)outputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AllTemplateSetInfoResp(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TStorageGroupSchema> getMatchedStorageGroupSchemasByOneName(String[] storageGroupPathPattern) {
        HashMap<String, TStorageGroupSchema> schemaMap = new HashMap<String, TStorageGroupSchema>();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(storageGroupPathPattern);
            List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByPath(path).getStorageGroupSchema());
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error StorageGroup name", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    public void clear() {
        this.mTree.clear();
    }
}

