/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.persistence.partition.RegionMaintainTask;
import org.apache.iotdb.confignode.persistence.partition.RegionMaintainType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RegionCreateTask
extends RegionMaintainTask {
    private String storageGroup;
    private TRegionReplicaSet regionReplicaSet;
    private long TTL;

    public RegionCreateTask() {
        super(RegionMaintainType.CREATE);
    }

    public RegionCreateTask(TDataNodeLocation targetDataNode, String storageGroup, TRegionReplicaSet regionReplicaSet) {
        super(RegionMaintainType.CREATE);
        this.targetDataNode = targetDataNode;
        this.storageGroup = storageGroup;
        this.regionReplicaSet = regionReplicaSet;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public long getTTL() {
        return this.TTL;
    }

    public RegionCreateTask setTTL(long TTL) {
        this.TTL = TTL;
        return this;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(RegionMaintainType.CREATE.ordinal());
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.targetDataNode, (DataOutputStream)stream);
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)this.regionReplicaSet, (DataOutputStream)stream);
        if (TConsensusGroupType.DataRegion.equals((Object)this.regionReplicaSet.getRegionId().getType())) {
            ReadWriteIOUtils.write((long)this.TTL, (OutputStream)stream);
        }
    }

    @Override
    protected void deserialize(ByteBuffer buffer) throws IOException {
        this.targetDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
        this.storageGroup = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.regionReplicaSet = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)buffer);
        if (TConsensusGroupType.DataRegion.equals((Object)this.regionReplicaSet.getRegionId().getType())) {
            this.TTL = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)RegionMaintainType.CREATE.ordinal(), (OutputStream)outputStream);
        this.targetDataNode.write(protocol);
        ReadWriteIOUtils.write((String)this.storageGroup, (OutputStream)outputStream);
        this.regionReplicaSet.write(protocol);
        if (TConsensusGroupType.DataRegion.equals((Object)this.regionReplicaSet.getRegionId().getType())) {
            ReadWriteIOUtils.write((long)this.TTL, (OutputStream)outputStream);
        }
    }

    @Override
    protected void deserialize(InputStream inputStream, TProtocol protocol) throws TException, IOException {
        this.targetDataNode = new TDataNodeLocation();
        this.targetDataNode.read(protocol);
        this.storageGroup = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.regionReplicaSet = new TRegionReplicaSet();
        this.regionReplicaSet.read(protocol);
        if (TConsensusGroupType.DataRegion.equals((Object)this.regionReplicaSet.getRegionId().getType())) {
            this.TTL = ReadWriteIOUtils.readLong((InputStream)inputStream);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegionCreateTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegionCreateTask that = (RegionCreateTask)o;
        return this.TTL == that.TTL && this.storageGroup.equals(that.storageGroup) && this.regionReplicaSet.equals(that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storageGroup, this.regionReplicaSet, this.TTL);
    }
}

