/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.RegionHeartbeatSample;
import org.apache.iotdb.tsfile.utils.Pair;

public class RegionCache {
    private final List<RegionHeartbeatSample> slidingWindow = Collections.synchronizedList(new LinkedList());
    private volatile long versionTimestamp = 0L;
    private volatile RegionStatus status = RegionStatus.Unknown;
    private volatile boolean isLeader = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheHeartbeatSample(RegionHeartbeatSample newHeartbeatSample) {
        List<RegionHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            if (this.slidingWindow.size() == 0 || this.getLastSample().getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics() {
        List<RegionHeartbeatSample> list = this.slidingWindow;
        synchronized (list) {
            RegionHeartbeatSample lastSample = this.getLastSample();
            if (lastSample.getSendTimestamp() > this.versionTimestamp) {
                this.versionTimestamp = lastSample.getSendTimestamp();
                this.isLeader = lastSample.isLeader();
                this.status = lastSample.getStatus();
            }
        }
        if (System.currentTimeMillis() - this.versionTimestamp > 20000L) {
            this.status = RegionStatus.Unknown;
        }
    }

    public RegionStatus getStatus() {
        return this.status;
    }

    public Pair<Long, Boolean> isLeader() {
        return new Pair((Object)this.versionTimestamp, (Object)this.isLeader);
    }

    private RegionHeartbeatSample getLastSample() {
        return this.slidingWindow.get(this.slidingWindow.size() - 1);
    }
}

