/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;

public class NodeHeartbeatSample {
    private final long sendTimestamp;
    private final long receiveTimestamp;
    private NodeStatus status;
    private String statusReason;
    private short cpuUsageRate;
    private double memoryUsageRate;
    private double diskUsageRate;

    public NodeHeartbeatSample(long sendTimestamp, long receiveTimestamp) {
        this.sendTimestamp = sendTimestamp;
        this.receiveTimestamp = receiveTimestamp;
    }

    public NodeHeartbeatSample(THeartbeatResp heartbeatResp, long receiveTimestamp) {
        this.sendTimestamp = heartbeatResp.getHeartbeatTimestamp();
        this.receiveTimestamp = receiveTimestamp;
        this.status = NodeStatus.parse((String)heartbeatResp.getStatus());
        String string = this.statusReason = heartbeatResp.isSetStatusReason() ? heartbeatResp.getStatusReason() : null;
        if (heartbeatResp.isSetLoadSample()) {
            TLoadSample loadSample = heartbeatResp.getLoadSample();
            this.cpuUsageRate = loadSample.getCpuUsageRate();
            this.memoryUsageRate = loadSample.getMemoryUsageRate();
            this.diskUsageRate = loadSample.getDiskUsageRate();
        }
    }

    public long getSendTimestamp() {
        return this.sendTimestamp;
    }

    public long getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public short getCpuUsageRate() {
        return this.cpuUsageRate;
    }

    public double getMemoryUsageRate() {
        return this.memoryUsageRate;
    }

    public double getDiskUsageRate() {
        return this.diskUsageRate;
    }
}

