/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.node.NodeHeartbeatSample;

public abstract class BaseNodeCache {
    public static final int HEARTBEAT_TIMEOUT_TIME = 20000;
    public static final int MAXIMUM_WINDOW_SIZE = 100;
    final LinkedList<NodeHeartbeatSample> slidingWindow = new LinkedList();
    volatile NodeStatus status = NodeStatus.Unknown;
    volatile String statusReason;

    public abstract void cacheHeartbeatSample(NodeHeartbeatSample var1);

    public abstract boolean updateNodeStatus();

    public abstract long getLoadScore();

    public NodeStatus getNodeStatus() {
        return NodeStatus.parse((String)this.status.getStatus());
    }

    public String getNodeStatusWithReason() {
        if (this.statusReason == null) {
            return this.status.getStatus();
        }
        return this.status.getStatus() + "(" + this.statusReason + ")";
    }

    public void setRemoving() {
        this.status = NodeStatus.Removing;
    }
}

