/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.IRouter;
import org.apache.iotdb.tsfile.utils.Pair;

public class LoadScoreGreedyRouter
implements IRouter {
    private final Map<Integer, Long> loadScoreMap;

    public LoadScoreGreedyRouter(Map<Integer, Long> loadScoreMap) {
        this.loadScoreMap = loadScoreMap;
    }

    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> genLatestRegionRouteMap(List<TRegionReplicaSet> replicaSets) {
        ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet> result = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        replicaSets.forEach(replicaSet -> {
            TRegionReplicaSet sortedReplicaSet = new TRegionReplicaSet();
            sortedReplicaSet.setRegionId(replicaSet.getRegionId());
            Vector<Pair> sortList = new Vector<Pair>();
            replicaSet.getDataNodeLocations().forEach(dataNodeLocation -> sortList.add(new Pair((Object)this.loadScoreMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> Long.MAX_VALUE), dataNodeLocation)));
            sortList.sort(Comparator.comparingDouble(Pair::getLeft));
            for (Pair entry : sortList) {
                sortedReplicaSet.addToDataNodeLocations((TDataNodeLocation)entry.getRight());
            }
            result.put(sortedReplicaSet.getRegionId(), sortedReplicaSet);
        });
        return result;
    }
}

