/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.IRouter;

public class LazyGreedyRouter
implements IRouter {
    private final Set<Integer> disabledDataNodes = Collections.synchronizedSet(new HashSet());
    private final Map<TConsensusGroupId, TRegionReplicaSet> routeMap = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisabledDataNodes(List<TDataNodeConfiguration> disabledDataNodes) {
        Set<Integer> set = this.disabledDataNodes;
        synchronized (set) {
            this.disabledDataNodes.clear();
            this.disabledDataNodes.addAll(disabledDataNodes.stream().map(dataNodeConfiguration -> dataNodeConfiguration.getLocation().getDataNodeId()).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> genLatestRegionRouteMap(List<TRegionReplicaSet> replicaSets) {
        Set<Integer> set = this.disabledDataNodes;
        synchronized (set) {
            HashMap<Integer, Integer> leaderCounter = new HashMap<Integer, Integer>();
            ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet> result = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
            ArrayList<TRegionReplicaSet> updateReplicas = new ArrayList<TRegionReplicaSet>();
            for (TRegionReplicaSet replicaSet : replicaSets) {
                if (this.routeEntryNeedsUpdate(replicaSet)) {
                    updateReplicas.add(replicaSet);
                    continue;
                }
                leaderCounter.compute(((TDataNodeLocation)this.routeMap.get(replicaSet.getRegionId()).getDataNodeLocations().get(0)).getDataNodeId(), (dataNodeId, counter) -> counter == null ? 1 : counter + 1);
                result.put(replicaSet.getRegionId(), this.routeMap.get(replicaSet.getRegionId()));
            }
            for (TRegionReplicaSet replicaSet : updateReplicas) {
                this.updateRouteEntry(replicaSet, leaderCounter);
                result.put(replicaSet.getRegionId(), this.routeMap.get(replicaSet.getRegionId()));
            }
            return result;
        }
    }

    private boolean routeEntryNeedsUpdate(TRegionReplicaSet replicaSet) {
        Set inputReplicaSet;
        TConsensusGroupId groupId = replicaSet.getRegionId();
        if (!this.routeMap.containsKey(groupId)) {
            return true;
        }
        Set cacheReplicaSet = this.routeMap.get(groupId).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet());
        if (!cacheReplicaSet.equals(inputReplicaSet = replicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()))) {
            return true;
        }
        return this.disabledDataNodes.contains(((TDataNodeLocation)this.routeMap.get(groupId).getDataNodeLocations().get(0)).getDataNodeId());
    }

    private void updateRouteEntry(TRegionReplicaSet replicaSet, Map<Integer, Integer> leaderCounter) {
        TRegionReplicaSet newRouteEntry = new TRegionReplicaSet(replicaSet);
        Collections.shuffle(newRouteEntry.getDataNodeLocations(), new Random());
        int leaderIndex = -1;
        int locateLeaderCount = Integer.MAX_VALUE;
        for (int i = 0; i < newRouteEntry.getDataNodeLocationsSize(); ++i) {
            int currentDataNodeId = ((TDataNodeLocation)newRouteEntry.getDataNodeLocations().get(i)).getDataNodeId();
            if (this.disabledDataNodes.contains(currentDataNodeId) || leaderCounter.getOrDefault(currentDataNodeId, 0) >= locateLeaderCount) continue;
            leaderIndex = i;
            locateLeaderCount = leaderCounter.getOrDefault(currentDataNodeId, 0);
        }
        if (leaderIndex == -1) {
            leaderIndex = 0;
        }
        Collections.swap(newRouteEntry.getDataNodeLocations(), 0, leaderIndex);
        leaderCounter.compute(((TDataNodeLocation)newRouteEntry.getDataNodeLocations().get(0)).getDataNodeId(), (dataNodeId, counter) -> counter == null ? 1 : counter + 1);
        this.routeMap.put(newRouteEntry.getRegionId(), newRouteEntry);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getRouteMap() {
        return this.routeMap;
    }
}

