/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.consensus.request.read.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetTriggerTablePlan;
import org.apache.iotdb.confignode.consensus.response.TriggerJarResp;
import org.apache.iotdb.confignode.consensus.response.TriggerTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerJarReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerJarResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.trigger.api.enums.TriggerType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerManager.class);
    private final ConfigManager configManager;
    private final TriggerInfo triggerInfo;

    public TriggerManager(ConfigManager configManager, TriggerInfo triggerInfo) {
        this.configManager = configManager;
        this.triggerInfo = triggerInfo;
    }

    public TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    public TSStatus createTrigger(TCreateTriggerReq req) {
        boolean isStateful = TriggerType.construct((byte)req.getTriggerType()) == TriggerType.STATEFUL;
        TDataNodeLocation dataNodeLocation = isStateful ? this.configManager.getNodeManager().getLowestLoadDataNode() : null;
        TriggerInformation triggerInformation = new TriggerInformation((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)req.pathPattern), req.getTriggerName(), req.getClassName(), req.getJarPath(), req.getAttributes(), TriggerEvent.construct((byte)req.triggerEvent), TTriggerState.INACTIVE, isStateful, dataNodeLocation, req.getJarMD5());
        return this.configManager.getProcedureManager().createTrigger(triggerInformation, new Binary(req.getJarFile()));
    }

    public TSStatus dropTrigger(TDropTriggerReq req) {
        return this.configManager.getProcedureManager().dropTrigger(req.getTriggerName());
    }

    public TGetTriggerTableResp getTriggerTable() {
        try {
            return ((TriggerTableResp)this.configManager.getConsensusManager().read(new GetTriggerTablePlan()).getDataset()).convertToThriftResponse();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get TriggerTable", (Throwable)e);
            return new TGetTriggerTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetTriggerJarResp getTriggerJar(TGetTriggerJarReq req) {
        try {
            return ((TriggerJarResp)this.configManager.getConsensusManager().read(new GetTriggerJarPlan(req.getJarNameList())).getDataset()).convertToThriftResponse();
        }
        catch (IOException e) {
            LOGGER.error("Fail to get TriggerJar", (Throwable)e);
            return new TGetTriggerJarResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TSStatus transferTrigger(List<TDataNodeLocation> newUnknownDataList) {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }
}

