/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.DropTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.DeleteStorageGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.CreatePipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.DropPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StartPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StopPipeProcedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.store.ConfigProcedureStore;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureStore;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureManager.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private static final int PROCEDURE_WAIT_TIME_OUT = 30;
    private static final int PROCEDURE_WAIT_RETRY_TIMEOUT = 250;
    private final ConfigManager configManager;
    private ProcedureExecutor<ConfigNodeProcedureEnv> executor;
    private ProcedureScheduler scheduler;
    private IProcedureStore store;
    private ConfigNodeProcedureEnv env;

    public ProcedureManager(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.scheduler = new SimpleProcedureScheduler();
        this.store = new ConfigProcedureStore(configManager, procedureInfo);
        this.env = new ConfigNodeProcedureEnv(configManager, this.scheduler);
        this.executor = new ProcedureExecutor<ConfigNodeProcedureEnv>(this.env, this.store, this.scheduler);
    }

    public void shiftExecutor(boolean running) {
        if (running) {
            if (!this.executor.isRunning()) {
                this.executor.init(CONFIG_NODE_CONFIG.getProcedureCoreWorkerThreadsSize());
                this.executor.startWorkers();
                this.executor.startCompletedCleaner(CONFIG_NODE_CONFIG.getProcedureCompletedCleanInterval(), CONFIG_NODE_CONFIG.getProcedureCompletedEvictTTL());
                this.store.start();
                LOGGER.info("ProcedureManager is started successfully.");
            }
        } else if (this.executor.isRunning()) {
            this.executor.stop();
            if (!this.executor.isRunning()) {
                this.executor.join();
                this.store.stop();
                LOGGER.info("ProcedureManager is stopped successfully.");
            }
        }
    }

    public TSStatus deleteStorageGroups(ArrayList<TStorageGroupSchema> deleteSgSchemaList) {
        ArrayList<Long> procedureIds = new ArrayList<Long>();
        for (TStorageGroupSchema storageGroupSchema : deleteSgSchemaList) {
            DeleteStorageGroupProcedure deleteStorageGroupProcedure = new DeleteStorageGroupProcedure(storageGroupSchema);
            long procedureId = this.executor.submitProcedure(deleteStorageGroupProcedure);
            procedureIds.add(procedureId);
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(procedureIds, procedureStatus);
        PartitionManager partitionManager = this.getConfigManager().getPartitionManager();
        partitionManager.getRegionMaintainer().submit(partitionManager::maintainRegionReplicas);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return RpcUtils.getStatus(procedureStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteTimeSeries(TDeleteTimeSeriesReq req) {
        String queryId = req.getQueryId();
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        long procedureId = -1L;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure procedure : this.executor.getProcedures().values()) {
                ProcedureFactory.ProcedureType type = ProcedureFactory.getProcedureType(procedure);
                if (type == null || !type.equals((Object)ProcedureFactory.ProcedureType.DELETE_TIMESERIES_PROCEDURE)) continue;
                DeleteTimeSeriesProcedure deleteTimeSeriesProcedure = (DeleteTimeSeriesProcedure)procedure;
                if (queryId.equals(deleteTimeSeriesProcedure.getQueryId())) {
                    procedureId = deleteTimeSeriesProcedure.getProcId();
                    break;
                }
                if (!patternTree.isOverlapWith(deleteTimeSeriesProcedure.getPatternTree())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedureId == -1L) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_DELETE_TIMESERIES_TASK, (String)"Some other task is deleting some target timeseries.");
                }
                procedureId = this.executor.submitProcedure(new DeleteTimeSeriesProcedure(queryId, patternTree));
            }
        }
        ArrayList<TSStatus> procedureStatus = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), procedureStatus);
        if (isSucceed) {
            return StatusUtils.OK;
        }
        return (TSStatus)procedureStatus.get(0);
    }

    public void addConfigNode(TConfigNodeRegisterReq req) {
        AddConfigNodeProcedure addConfigNodeProcedure = new AddConfigNodeProcedure(req.getConfigNodeLocation());
        this.executor.submitProcedure(addConfigNodeProcedure);
    }

    public void removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        RemoveConfigNodeProcedure removeConfigNodeProcedure = new RemoveConfigNodeProcedure(removeConfigNodePlan.getConfigNodeLocation());
        this.executor.submitProcedure(removeConfigNodeProcedure);
        LOGGER.info("Submit RemoveConfigNodeProcedure successfully: {}", (Object)removeConfigNodePlan);
    }

    public boolean removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        removeDataNodePlan.getDataNodeLocations().forEach(tDataNodeLocation -> {
            this.executor.submitProcedure(new RemoveDataNodeProcedure((TDataNodeLocation)tDataNodeLocation));
            LOGGER.info("Submit to remove data node procedure, {}", tDataNodeLocation);
        });
        return true;
    }

    public TSStatus createRegionGroups(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        long procedureId = this.executor.submitProcedure(new CreateRegionGroupsProcedure(consensusGroupType, createRegionGroupsPlan));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus createTrigger(TriggerInformation triggerInformation, Binary jarFile) {
        long procedureId = this.executor.submitProcedure(new CreateTriggerProcedure(triggerInformation, jarFile));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus dropTrigger(String triggerName) {
        long procedureId = this.executor.submitProcedure(new DropTriggerProcedure(triggerName));
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
        if (isSucceed) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return new TSStatus(TSStatusCode.DROP_TRIGGER_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
    }

    public TSStatus createPipe(TPipeInfo req) {
        try {
            long procedureId = this.executor.submitProcedure(new CreatePipeProcedure(req));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus startPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new StartPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus stopPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new StopPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropPipe(String pipeName) {
        try {
            long procedureId = this.executor.submitProcedure(new DropPipeProcedure(pipeName));
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            boolean isSucceed = this.waitingProcedureFinished(Collections.singletonList(procedureId), statusList);
            if (isSucceed) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(((TSStatus)statusList.get(0)).getMessage());
        }
        catch (PipeException e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    private boolean waitingProcedureFinished(List<Long> procedureIds, List<TSStatus> statusList) {
        boolean isSucceed = true;
        for (long procedureId : procedureIds) {
            long startTimeForCurrentProcedure = System.currentTimeMillis();
            while (this.executor.isRunning() && !this.executor.isFinished(procedureId) && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeForCurrentProcedure) < 30L) {
                ProcedureManager.sleepWithoutInterrupt(250L);
            }
            Procedure<ConfigNodeProcedureEnv> finishedProcedure = this.executor.getResultOrProcedure(procedureId);
            if (!finishedProcedure.isFinished()) {
                statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.STILL_EXECUTING_STATUS));
                isSucceed = false;
                continue;
            }
            if (finishedProcedure.isSuccess()) {
                statusList.add(StatusUtils.OK);
                continue;
            }
            if (finishedProcedure.getException().getCause() instanceof IoTDBException) {
                IoTDBException e = (IoTDBException)finishedProcedure.getException().getCause();
                statusList.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            } else {
                statusList.add(StatusUtils.EXECUTE_STATEMENT_ERROR.setMessage(finishedProcedure.getException().getMessage()));
            }
            isSucceed = false;
        }
        return isSucceed;
    }

    public static void sleepWithoutInterrupt(long timeToSleep) {
        long currentTime = System.currentTimeMillis();
        long endTime = timeToSleep + currentTime;
        boolean interrupted = false;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            currentTime = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public IManager getConfigManager() {
        return this.configManager;
    }

    public ProcedureExecutor<ConfigNodeProcedureEnv> getExecutor() {
        return this.executor;
    }

    public void setExecutor(ProcedureExecutor<ConfigNodeProcedureEnv> executor) {
        this.executor = executor;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ProcedureScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProcedureStore getStore() {
        return this.store;
    }

    public void setStore(ProcedureStore store) {
        this.store = store;
    }

    public ConfigNodeProcedureEnv getEnv() {
        return this.env;
    }

    public void setEnv(ConfigNodeProcedureEnv env) {
        this.env = env;
    }

    public void reportRegionMigrateResult(TRegionMigrateResultReportReq req) {
        this.executor.getProcedures().values().forEach(procedure -> {
            RegionMigrateProcedure regionMigrateProcedure;
            if (procedure instanceof RegionMigrateProcedure && (regionMigrateProcedure = (RegionMigrateProcedure)procedure).getConsensusGroupId().equals(req.getRegionId())) {
                regionMigrateProcedure.notifyTheRegionMigrateFinished(req);
            }
        });
    }
}

