/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;

public class SchemaNodeManagementResp
implements DataSet {
    private TSStatus status;
    private Map<String, SchemaPartitionTable> schemaPartition;
    private Set<TSchemaNode> matchedNode;

    public TSStatus getStatus() {
        return this.status;
    }

    public void setStatus(TSStatus status) {
        this.status = status;
    }

    public void setSchemaPartition(Map<String, SchemaPartitionTable> schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    public void setMatchedNode(Set<TSchemaNode> matchedNode) {
        this.matchedNode = matchedNode;
    }

    public TSchemaNodeManagementResp convertToRpcSchemaNodeManagementPartitionResp(Map<TConsensusGroupId, TRegionReplicaSet> replicaSetMap) {
        TSchemaNodeManagementResp resp = new TSchemaNodeManagementResp();
        resp.setStatus(this.status);
        if (this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setMatchedNode(this.matchedNode);
            ConcurrentHashMap schemaPartitionMap = new ConcurrentHashMap();
            this.schemaPartition.forEach((storageGroup, schemaPartitionTable) -> {
                ConcurrentHashMap seriesPartitionSlotMap = new ConcurrentHashMap();
                schemaPartitionTable.getSchemaPartitionMap().forEach((seriesPartitionSlot, consensusGroupId) -> seriesPartitionSlotMap.put(seriesPartitionSlot, (TRegionReplicaSet)replicaSetMap.get(consensusGroupId)));
                schemaPartitionMap.put(storageGroup, seriesPartitionSlotMap);
            });
            resp.setSchemaRegionMap(schemaPartitionMap);
        }
        return resp;
    }
}

