/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeStartupCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeStartupCheck.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();

    public void startUpCheck() throws StartupException, IOException, ConfigurationException {
        this.checkGlobalConfig();
        this.createDirsIfNecessary();
        if (SystemPropertiesUtils.isRestarted()) {
            SystemPropertiesUtils.checkSystemProperties();
        }
    }

    private void checkGlobalConfig() throws ConfigurationException {
        if (CONF.getConfigNodeConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && (!CONF.getInternalAddress().equals(CONF.getTargetConfigNode().getIp()) || CONF.getInternalPort() != CONF.getTargetConfigNode().getPort())) {
            throw new ConfigurationException("target_config_nodes", CONF.getTargetConfigNode().getIp() + ":" + CONF.getTargetConfigNode().getPort(), CONF.getInternalAddress() + ":" + CONF.getInternalPort());
        }
        if (CONF.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && CONF.getDataReplicationFactor() != 1) {
            throw new ConfigurationException("data_replication_factor", String.valueOf(CONF.getDataReplicationFactor()), String.valueOf(1));
        }
        if (CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.standalone.StandAloneConsensus") && CONF.getSchemaReplicationFactor() != 1) {
            throw new ConfigurationException("schema_replication_factor", String.valueOf(CONF.getSchemaReplicationFactor()), String.valueOf(1));
        }
        if (CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            throw new ConfigurationException("schema_region_consensus_protocol_class", String.valueOf(CONF.getSchemaRegionConsensusProtocolClass()), String.format("%s or %s", "org.apache.iotdb.consensus.standalone.StandAloneConsensus", "org.apache.iotdb.consensus.ratis.RatisConsensus"));
        }
        if (!CONF.getRoutingPolicy().equals("leader") && !CONF.getRoutingPolicy().equals("greedy")) {
            throw new ConfigurationException("routing_policy", CONF.getRoutingPolicy(), "leader or greedy");
        }
        if (CONF.getTargetConfigNode().getIp().equals("0.0.0.0")) {
            throw new ConfigurationException("The ip address of any target_config_nodes couldn't be 0.0.0.0");
        }
    }

    private void createDirsIfNecessary() throws IOException {
        File systemDir = new File(CONF.getSystemDir());
        this.createDirIfEmpty(systemDir);
        File consensusDir = new File(CONF.getConsensusDir());
        this.createDirIfEmpty(consensusDir);
    }

    private void createDirIfEmpty(File dir) throws IOException {
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOGGER.info("Make dirs: {}", (Object)dir);
            } else {
                throw new IOException(String.format("Start ConfigNode failed, because couldn't make system dirs: %s.", dir.getAbsolutePath()));
            }
        }
    }

    public static ConfigNodeStartupCheck getInstance() {
        return ConfigNodeConfCheckHolder.INSTANCE;
    }

    private static class ConfigNodeConfCheckHolder {
        private static final ConfigNodeStartupCheck INSTANCE = new ConfigNodeStartupCheck();

        private ConfigNodeConfCheckHolder() {
        }
    }
}

