/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;

public class ConfigNodeConfig {
    private volatile int configNodeId = -1;
    private String internalAddress = "0.0.0.0";
    private int internalPort = 22277;
    private int consensusPort = 22278;
    private TEndPoint targetConfigNode = new TEndPoint("127.0.0.1", 22277);
    private int partitionRegionId = 0;
    private String configNodeConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double schemaRegionPerDataNode = 1.0;
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double dataRegionPerProcessor = 0.5;
    private RegionBalancer.RegionAllocateStrategy regionAllocateStrategy = RegionBalancer.RegionAllocateStrategy.GREEDY;
    private int seriesPartitionSlotNum = 10000;
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private int rpcMaxConcurrentClientNum = 65535;
    private boolean rpcAdvancedCompressionEnable = false;
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int thriftServerAwaitTimeForStopService = 60;
    private String systemDir = "data" + File.separator + "system";
    private String consensusDir = "data" + File.separator + "consensus";
    private String extLibDir = "ext";
    private String udfLibDir = "ext" + File.separator + "udf";
    private String triggerLibDir = "ext" + File.separator + "trigger";
    private String temporaryLibDir = "ext" + File.separator + "udf_temporary";
    private long timePartitionInterval = 604800000L;
    private int schemaReplicationFactor = 1;
    private int dataReplicationFactor = 1;
    private int procedureCompletedEvictTTL = 800;
    private int procedureCompletedCleanInterval = 30;
    private int procedureCoreWorkerThreadsSize = Math.max(Runtime.getRuntime().availableProcessors() / 4, 16);
    private long heartbeatInterval;
    private long unknownDataNodeDetectInterval = this.heartbeatInterval = 1000L;
    private String routingPolicy = "leader";
    private String readConsistencyLevel = "strong";
    private long dataRegionRatisConsensusLogAppenderBufferSize = 0x400000L;
    private long partitionRegionRatisConsensusLogAppenderBufferSize = 0x400000L;
    private long schemaRegionRatisConsensusLogAppenderBufferSize = 0x400000L;
    private long dataRegionRatisSnapshotTriggerThreshold = 400000L;
    private long partitionRegionRatisSnapshotTriggerThreshold = 400000L;
    private long schemaRegionRatisSnapshotTriggerThreshold = 400000L;
    private boolean dataRegionRatisLogUnsafeFlushEnable = false;
    private boolean partitionRegionRatisLogUnsafeFlushEnable = false;
    private boolean schemaRegionRatisLogUnsafeFlushEnable = false;
    private long dataRegionRatisLogSegmentSizeMax = 0x1800000L;
    private long partitionRegionRatisLogSegmentSizeMax = 0x1800000L;
    private long schemaRegionRatisLogSegmentSizeMax = 0x1800000L;
    private long dataRegionRatisGrpcFlowControlWindow = 0x400000L;
    private long partitionRegionRatisGrpcFlowControlWindow = 0x400000L;
    private long schemaRegionRatisGrpcFlowControlWindow = 0x400000L;
    private long dataRegionRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long partitionRegionRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long schemaRegionRatisRpcLeaderElectionTimeoutMinMs = 2000L;
    private long dataRegionRatisRpcLeaderElectionTimeoutMaxMs = 4000L;
    private long partitionRegionRatisRpcLeaderElectionTimeoutMaxMs = 4000L;
    private long schemaRegionRatisRpcLeaderElectionTimeoutMaxMs = 4000L;

    public void updatePath() {
        this.formulateFolders();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.consensusDir = this.addHomeDir(this.consensusDir);
        this.extLibDir = this.addHomeDir(this.extLibDir);
        this.udfLibDir = this.addHomeDir(this.udfLibDir);
        this.temporaryLibDir = this.addHomeDir(this.temporaryLibDir);
        this.triggerLibDir = this.addHomeDir(this.triggerLibDir);
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("CONFIGNODE_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public int getConfigNodeId() {
        return this.configNodeId;
    }

    public void setConfigNodeId(int configNodeId) {
        this.configNodeId = configNodeId;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getConsensusPort() {
        return this.consensusPort;
    }

    public void setConsensusPort(int consensusPort) {
        this.consensusPort = consensusPort;
    }

    public TEndPoint getTargetConfigNode() {
        return this.targetConfigNode;
    }

    public void setTargetConfigNode(TEndPoint targetConfigNode) {
        this.targetConfigNode = targetConfigNode;
    }

    public int getPartitionRegionId() {
        return this.partitionRegionId;
    }

    public void setPartitionRegionId(int partitionRegionId) {
        this.partitionRegionId = partitionRegionId;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    public void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
    }

    public String getConfigNodeConsensusProtocolClass() {
        return this.configNodeConsensusProtocolClass;
    }

    public void setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.configNodeConsensusProtocolClass = configNodeConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public double getSchemaRegionPerDataNode() {
        return this.schemaRegionPerDataNode;
    }

    public void setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.schemaRegionPerDataNode = schemaRegionPerDataNode;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public double getDataRegionPerProcessor() {
        return this.dataRegionPerProcessor;
    }

    public void setDataRegionPerProcessor(double dataRegionPerProcessor) {
        this.dataRegionPerProcessor = dataRegionPerProcessor;
    }

    public RegionBalancer.RegionAllocateStrategy getRegionAllocateStrategy() {
        return this.regionAllocateStrategy;
    }

    public void setRegionAllocateStrategy(RegionBalancer.RegionAllocateStrategy regionAllocateStrategy) {
        this.regionAllocateStrategy = regionAllocateStrategy;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    public void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSystemUdfDir() {
        return this.getSystemDir() + File.separator + "udf" + File.separator;
    }

    public String getUdfLibDir() {
        return this.udfLibDir;
    }

    public void setUdfLibDir(String udfLibDir) {
        this.udfLibDir = udfLibDir;
    }

    public String getExtLibDir() {
        return this.extLibDir;
    }

    public void setExtLibDir(String extLibDir) {
        this.extLibDir = extLibDir;
    }

    public String getTriggerLibDir() {
        return this.triggerLibDir;
    }

    public void setTriggerLibDir(String triggerLibDir) {
        this.triggerLibDir = triggerLibDir;
    }

    public String getTemporaryLibDir() {
        return this.temporaryLibDir;
    }

    public void setTemporaryLibDir(String temporaryLibDir) {
        this.temporaryLibDir = temporaryLibDir;
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(int dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public int getProcedureCompletedEvictTTL() {
        return this.procedureCompletedEvictTTL;
    }

    public void setProcedureCompletedEvictTTL(int procedureCompletedEvictTTL) {
        this.procedureCompletedEvictTTL = procedureCompletedEvictTTL;
    }

    public int getProcedureCompletedCleanInterval() {
        return this.procedureCompletedCleanInterval;
    }

    public void setProcedureCompletedCleanInterval(int procedureCompletedCleanInterval) {
        this.procedureCompletedCleanInterval = procedureCompletedCleanInterval;
    }

    public int getProcedureCoreWorkerThreadsSize() {
        return this.procedureCoreWorkerThreadsSize;
    }

    public void setProcedureCoreWorkerThreadsSize(int procedureCoreWorkerThreadsSize) {
        this.procedureCoreWorkerThreadsSize = procedureCoreWorkerThreadsSize;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public long getUnknownDataNodeDetectInterval() {
        return this.unknownDataNodeDetectInterval;
    }

    public void setUnknownDataNodeDetectInterval(long unknownDataNodeDetectInterval) {
        this.unknownDataNodeDetectInterval = unknownDataNodeDetectInterval;
    }

    public String getRoutingPolicy() {
        return this.routingPolicy;
    }

    public void setRoutingPolicy(String routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public long getDataRegionRatisConsensusLogAppenderBufferSize() {
        return this.dataRegionRatisConsensusLogAppenderBufferSize;
    }

    public void setDataRegionRatisConsensusLogAppenderBufferSize(long dataRegionRatisConsensusLogAppenderBufferSize) {
        this.dataRegionRatisConsensusLogAppenderBufferSize = dataRegionRatisConsensusLogAppenderBufferSize;
    }

    public long getDataRegionRatisSnapshotTriggerThreshold() {
        return this.dataRegionRatisSnapshotTriggerThreshold;
    }

    public void setDataRegionRatisSnapshotTriggerThreshold(long dataRegionRatisSnapshotTriggerThreshold) {
        this.dataRegionRatisSnapshotTriggerThreshold = dataRegionRatisSnapshotTriggerThreshold;
    }

    public boolean isDataRegionRatisLogUnsafeFlushEnable() {
        return this.dataRegionRatisLogUnsafeFlushEnable;
    }

    public void setDataRegionRatisLogUnsafeFlushEnable(boolean dataRegionRatisLogUnsafeFlushEnable) {
        this.dataRegionRatisLogUnsafeFlushEnable = dataRegionRatisLogUnsafeFlushEnable;
    }

    public long getDataRegionRatisLogSegmentSizeMax() {
        return this.dataRegionRatisLogSegmentSizeMax;
    }

    public void setDataRegionRatisLogSegmentSizeMax(long dataRegionRatisLogSegmentSizeMax) {
        this.dataRegionRatisLogSegmentSizeMax = dataRegionRatisLogSegmentSizeMax;
    }

    public long getDataRegionRatisGrpcFlowControlWindow() {
        return this.dataRegionRatisGrpcFlowControlWindow;
    }

    public void setDataRegionRatisGrpcFlowControlWindow(long dataRegionRatisGrpcFlowControlWindow) {
        this.dataRegionRatisGrpcFlowControlWindow = dataRegionRatisGrpcFlowControlWindow;
    }

    public long getDataRegionRatisRpcLeaderElectionTimeoutMinMs() {
        return this.dataRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setDataRegionRatisRpcLeaderElectionTimeoutMinMs(long dataRegionRatisRpcLeaderElectionTimeoutMinMs) {
        this.dataRegionRatisRpcLeaderElectionTimeoutMinMs = dataRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getDataRegionRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.dataRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setDataRegionRatisRpcLeaderElectionTimeoutMaxMs(long dataRegionRatisRpcLeaderElectionTimeoutMaxMs) {
        this.dataRegionRatisRpcLeaderElectionTimeoutMaxMs = dataRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public long getPartitionRegionRatisConsensusLogAppenderBufferSize() {
        return this.partitionRegionRatisConsensusLogAppenderBufferSize;
    }

    public void setPartitionRegionRatisConsensusLogAppenderBufferSize(long partitionRegionRatisConsensusLogAppenderBufferSize) {
        this.partitionRegionRatisConsensusLogAppenderBufferSize = partitionRegionRatisConsensusLogAppenderBufferSize;
    }

    public long getPartitionRegionRatisSnapshotTriggerThreshold() {
        return this.partitionRegionRatisSnapshotTriggerThreshold;
    }

    public void setPartitionRegionRatisSnapshotTriggerThreshold(long partitionRegionRatisSnapshotTriggerThreshold) {
        this.partitionRegionRatisSnapshotTriggerThreshold = partitionRegionRatisSnapshotTriggerThreshold;
    }

    public boolean isPartitionRegionRatisLogUnsafeFlushEnable() {
        return this.partitionRegionRatisLogUnsafeFlushEnable;
    }

    public void setPartitionRegionRatisLogUnsafeFlushEnable(boolean partitionRegionRatisLogUnsafeFlushEnable) {
        this.partitionRegionRatisLogUnsafeFlushEnable = partitionRegionRatisLogUnsafeFlushEnable;
    }

    public long getPartitionRegionRatisLogSegmentSizeMax() {
        return this.partitionRegionRatisLogSegmentSizeMax;
    }

    public void setPartitionRegionRatisLogSegmentSizeMax(long partitionRegionRatisLogSegmentSizeMax) {
        this.partitionRegionRatisLogSegmentSizeMax = partitionRegionRatisLogSegmentSizeMax;
    }

    public long getPartitionRegionRatisGrpcFlowControlWindow() {
        return this.partitionRegionRatisGrpcFlowControlWindow;
    }

    public void setPartitionRegionRatisGrpcFlowControlWindow(long partitionRegionRatisGrpcFlowControlWindow) {
        this.partitionRegionRatisGrpcFlowControlWindow = partitionRegionRatisGrpcFlowControlWindow;
    }

    public long getPartitionRegionRatisRpcLeaderElectionTimeoutMinMs() {
        return this.partitionRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setPartitionRegionRatisRpcLeaderElectionTimeoutMinMs(long partitionRegionRatisRpcLeaderElectionTimeoutMinMs) {
        this.partitionRegionRatisRpcLeaderElectionTimeoutMinMs = partitionRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getPartitionRegionRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.partitionRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setPartitionRegionRatisRpcLeaderElectionTimeoutMaxMs(long partitionRegionRatisRpcLeaderElectionTimeoutMaxMs) {
        this.partitionRegionRatisRpcLeaderElectionTimeoutMaxMs = partitionRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public long getSchemaRegionRatisConsensusLogAppenderBufferSize() {
        return this.schemaRegionRatisConsensusLogAppenderBufferSize;
    }

    public void setSchemaRegionRatisConsensusLogAppenderBufferSize(long schemaRegionRatisConsensusLogAppenderBufferSize) {
        this.schemaRegionRatisConsensusLogAppenderBufferSize = schemaRegionRatisConsensusLogAppenderBufferSize;
    }

    public long getSchemaRegionRatisSnapshotTriggerThreshold() {
        return this.schemaRegionRatisSnapshotTriggerThreshold;
    }

    public void setSchemaRegionRatisSnapshotTriggerThreshold(long schemaRegionRatisSnapshotTriggerThreshold) {
        this.schemaRegionRatisSnapshotTriggerThreshold = schemaRegionRatisSnapshotTriggerThreshold;
    }

    public boolean isSchemaRegionRatisLogUnsafeFlushEnable() {
        return this.schemaRegionRatisLogUnsafeFlushEnable;
    }

    public void setSchemaRegionRatisLogUnsafeFlushEnable(boolean schemaRegionRatisLogUnsafeFlushEnable) {
        this.schemaRegionRatisLogUnsafeFlushEnable = schemaRegionRatisLogUnsafeFlushEnable;
    }

    public long getSchemaRegionRatisLogSegmentSizeMax() {
        return this.schemaRegionRatisLogSegmentSizeMax;
    }

    public void setSchemaRegionRatisLogSegmentSizeMax(long schemaRegionRatisLogSegmentSizeMax) {
        this.schemaRegionRatisLogSegmentSizeMax = schemaRegionRatisLogSegmentSizeMax;
    }

    public long getSchemaRegionRatisGrpcFlowControlWindow() {
        return this.schemaRegionRatisGrpcFlowControlWindow;
    }

    public void setSchemaRegionRatisGrpcFlowControlWindow(long schemaRegionRatisGrpcFlowControlWindow) {
        this.schemaRegionRatisGrpcFlowControlWindow = schemaRegionRatisGrpcFlowControlWindow;
    }

    public long getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs() {
        return this.schemaRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public void setSchemaRegionRatisRpcLeaderElectionTimeoutMinMs(long schemaRegionRatisRpcLeaderElectionTimeoutMinMs) {
        this.schemaRegionRatisRpcLeaderElectionTimeoutMinMs = schemaRegionRatisRpcLeaderElectionTimeoutMinMs;
    }

    public long getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs() {
        return this.schemaRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }

    public void setSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs(long schemaRegionRatisRpcLeaderElectionTimeoutMaxMs) {
        this.schemaRegionRatisRpcLeaderElectionTimeoutMaxMs = schemaRegionRatisRpcLeaderElectionTimeoutMaxMs;
    }
}

