/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerClassLoader.class);
    private final String libRoot;

    public TriggerClassLoader(String libRoot) throws IOException {
        super(new URL[0]);
        this.libRoot = libRoot;
        LOGGER.info("Trigger lib root: {}", (Object)libRoot);
        this.addURLs();
    }

    private void addURLs() throws IOException {
        URL[] urls;
        HashSet fileSet = new HashSet(FileUtils.listFiles((File)SystemFileFactory.INSTANCE.getFile(this.libRoot), null, (boolean)true));
        for (URL url : urls = FileUtils.toURLs((File[])fileSet.toArray(new File[0]))) {
            super.addURL(url);
        }
    }
}

