/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public class DeletionGroup {
    private TreeMap<Long, Long> delIntervalMap = new TreeMap();

    public void addDelInterval(long startTime, long endTime) {
        if (startTime > endTime) {
            throw new IllegalArgumentException("addDelInterval(), error: startTime > endTime.");
        }
        Map.Entry<Long, Long> startEntry = this.delIntervalMap.floorEntry(startTime);
        Map.Entry<Long, Long> endEntry = this.delIntervalMap.floorEntry(endTime);
        if (startEntry != null && startTime <= startEntry.getValue()) {
            startTime = startEntry.getKey();
        }
        if (endEntry != null && endTime < endEntry.getValue()) {
            endTime = endEntry.getValue();
        }
        NavigableMap<Long, Long> overlapEntries = this.delIntervalMap.subMap(startTime, true, endTime, true);
        Iterator iter = overlapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.delIntervalMap.put(startTime, endTime);
    }

    public boolean isEmpty() {
        return this.delIntervalMap.isEmpty();
    }

    public DeletedType checkDeletedState(long startTime, long endTime) {
        Map.Entry<Long, Long> endEntry;
        if (this.delIntervalMap.isEmpty()) {
            return DeletedType.NO_DELETED;
        }
        if (startTime > endTime) {
            throw new IllegalArgumentException("checkDeletedState(), error: startTime > endTime.");
        }
        Map.Entry<Long, Long> startEntry = this.delIntervalMap.floorEntry(startTime);
        if (!Objects.equals(startEntry, endEntry = this.delIntervalMap.floorEntry(endTime))) {
            return DeletedType.PARTIAL_DELETED;
        }
        if (startEntry == null) {
            return DeletedType.NO_DELETED;
        }
        if (startTime > startEntry.getValue()) {
            return DeletedType.NO_DELETED;
        }
        if (endTime <= startEntry.getValue()) {
            return DeletedType.FULL_DELETED;
        }
        return DeletedType.PARTIAL_DELETED;
    }

    public boolean isDeleted(long ts) {
        if (this.delIntervalMap.isEmpty()) {
            return false;
        }
        Map.Entry<Long, Long> entry = this.delIntervalMap.floorEntry(ts);
        if (entry == null) {
            return false;
        }
        return ts <= entry.getValue();
    }

    public boolean isDeleted(long ts, IntervalCursor intervalCursor) {
        if (this.delIntervalMap.isEmpty()) {
            return false;
        }
        if (intervalCursor.iter == null) {
            Long floorKey = this.delIntervalMap.floorKey(ts);
            if (floorKey == null) {
                intervalCursor.iter = this.delIntervalMap.entrySet().iterator();
                intervalCursor.startTime = this.delIntervalMap.firstKey();
                intervalCursor.endTime = this.delIntervalMap.firstEntry().getValue();
                return false;
            }
            intervalCursor.iter = this.delIntervalMap.tailMap(floorKey, true).entrySet().iterator();
            Map.Entry<Long, Long> entry = intervalCursor.iter.next();
            intervalCursor.startTime = entry.getKey();
            intervalCursor.endTime = entry.getValue();
        }
        if (intervalCursor.subsequentNoDelete) {
            return false;
        }
        while (true) {
            if (ts < intervalCursor.startTime) {
                return false;
            }
            if (ts <= intervalCursor.endTime) {
                return true;
            }
            if (!intervalCursor.iter.hasNext()) break;
            Map.Entry<Long, Long> entry = intervalCursor.iter.next();
            intervalCursor.startTime = entry.getKey();
            intervalCursor.endTime = entry.getValue();
        }
        intervalCursor.subsequentNoDelete = true;
        return false;
    }

    public TreeMap<Long, Long> getDelIntervalMap() {
        return this.delIntervalMap;
    }

    public static class IntervalCursor {
        Iterator<Map.Entry<Long, Long>> iter = null;
        boolean subsequentNoDelete = false;
        public long startTime;
        public long endTime;

        public void reset() {
            this.iter = null;
            this.subsequentNoDelete = false;
        }
    }

    public static enum DeletedType {
        NO_DELETED,
        PARTIAL_DELETED,
        FULL_DELETED;

    }
}

